/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnDouble
extends TupleColumn {
    TupleColumnDouble(String name, Value value, int length, int maxLength) {
        super(name, Double.TYPE, value, length, maxLength);
    }

    protected void createArray(int size) {
        double[] data = new double[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getDouble();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        double[] data = (double[])this.currentArray;
        value.set(data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            double[] data = (double[])this.currentArray;
            data[index % this.arraySize] = value.getDouble();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnDouble");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getDouble());
        }
    }
}

