/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class PDGMCtoXML {
    static int PDGID = 0;
    static double Pmass = 0.0;
    static double PMPErr = 0.0;
    static double PMMErr = 0.0;
    static String PName = "";
    static double Pwidth = 0.0;
    static double PWPErr = 0.0;
    static double PWMErr = 0.0;
    static BufferedWriter outfile;

    protected static int getIDNumber(int i, String st) {
        String str1 = "";
        if (i > 3) {
            return 0;
        }
        if (st.trim() == " ") {
            return 0;
        }
        for (int j = 0; j <= 7; ++j) {
            char chr = st.charAt(j + i * 8 + 1);
            str1 = str1 + chr;
        }
        str1 = str1.trim();
        int wert = 0;
        try {
            wert = Integer.parseInt(str1);
        }
        catch (Exception e) {
            // empty catch block
        }
        return wert;
    }

    protected static double getvalue(String st) {
        String str1 = "";
        for (int j = 0; j <= 14; ++j) {
            char chr = st.charAt(j + 33);
            str1 = str1 + chr;
        }
        str1 = str1.trim();
        double wert = 0.0;
        try {
            wert = new Double(str1);
        }
        catch (Exception e) {
            // empty catch block
        }
        return wert;
    }

    protected static double geterror(String st, int i) {
        String str1 = "";
        for (int j = 0; j <= 8; ++j) {
            char chr = st.charAt(j + 49 + i * 9);
            str1 = str1 + chr;
        }
        str1 = str1.trim();
        double wert = 0.0;
        try {
            wert = new Double(str1);
        }
        catch (Exception e) {
            // empty catch block
        }
        return wert;
    }

    protected static String getname(String st) {
        String str1 = "";
        char chr = 'x';
        int j = 0;
        while (chr != ' ') {
            chr = st.charAt(j + 67);
            str1 = str1 + chr;
            ++j;
        }
        str1 = str1.trim();
        return str1;
    }

    protected static void writeinfo() {
        try {
            outfile.write("<Particle Name=\"" + PName + "\">");
            outfile.newLine();
            outfile.write("  <data Name=\"PDGID\" Value=\"" + PDGID + "\" />");
            outfile.newLine();
            outfile.write("  <data Name=\"Mass\" Value=\"" + Pmass + "\" PError=\"" + PMPErr + "\" MError=\"" + PMMErr + "\"/>");
            outfile.newLine();
            outfile.write("  <data Name=\"Width\" Value=\"" + Pwidth + "\" PError=\"" + PWPErr + "\" MError=\"" + PWMErr + "\"/>");
            outfile.newLine();
            outfile.write("</Particle>");
            outfile.newLine();
        }
        catch (IOException e) {
            System.out.println("Error .. " + e.toString());
        }
    }

    public static void main(String[] arguments) {
        try {
            FileReader myfile = new FileReader("hep/physics/yappi/util/garren_98.mc");
            BufferedReader infile = new BufferedReader(myfile);
            FileWriter mywriter = new FileWriter("hep/physics/yappi/util/garren_98_mc.xml");
            outfile = new BufferedWriter(mywriter);
            outfile.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            outfile.newLine();
            outfile.write("<PPML Source=\"PDGConv\">");
            outfile.newLine();
            outfile.write(" ");
            outfile.newLine();
            boolean eof = false;
            while (!eof) {
                String line = infile.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                if ((line = line.trim()).charAt(0) == 'M') {
                    if (PDGID != 0) {
                        PDGMCtoXML.writeinfo();
                    }
                    PDGID = PDGMCtoXML.getIDNumber(0, line);
                    Pmass = PDGMCtoXML.getvalue(line);
                    PMPErr = PDGMCtoXML.geterror(line, 0);
                    PMMErr = PDGMCtoXML.geterror(line, 1);
                    PName = PDGMCtoXML.getname(line);
                    continue;
                }
                if (line.charAt(0) != 'W') continue;
                Pwidth = PDGMCtoXML.getvalue(line);
                PWPErr = PDGMCtoXML.geterror(line, 0);
                PWMErr = PDGMCtoXML.geterror(line, 1);
            }
            PDGMCtoXML.writeinfo();
            outfile.write("</PPML>");
            outfile.newLine();
            outfile.close();
            infile.close();
        }
        catch (IOException e) {
            System.out.println("Error .. " + e.toString());
        }
    }
}

