/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi.servlet;

import hep.physics.yappi.Family;
import hep.physics.yappi.PDGID;
import hep.physics.yappi.ParticleType;
import hep.physics.yappi.XMLYappi;
import hep.physics.yappi.io.HTMLYappiWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.SAXException;

public class Lookup
extends HttpServlet {
    private final XMLYappi yappi = new XMLYappi();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String configfile = config.getInitParameter("YappiConfig");
        if (configfile == null) {
            configfile = "/hep/physics/yappi/servlet/YappiServlet.cfg";
        }
        try {
            this.loadXML(config.getServletContext(), configfile);
        }
        catch (Exception e) {
            throw new ServletException("Yappi Particle Lookup", (Throwable)e);
        }
    }

    private void loadXML(ServletContext context, String configfile) throws IOException, SAXException {
        URL url = context.getResource(configfile);
        if (url != null) {
            String line;
            System.out.println("Loading configfile from URL: " + url);
            BufferedReader infile = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = infile.readLine()) != null) {
                if (line.startsWith("#")) continue;
                url = context.getResource(line = line.trim());
                if (url != null) {
                    System.out.println("Loading XML file from URL: " + url);
                    this.yappi.read(new BufferedReader(new InputStreamReader(url.openStream())));
                    continue;
                }
                System.out.println("Resource: " + line + " not available");
            }
            infile.close();
        } else {
            System.out.println("Resource: " + configfile + " not available");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        HTMLYappiWriter writer = new HTMLYappiWriter(out);
        if (request.getParameter("particle") != null) {
            String name = request.getParameter("particle");
            this.writeParticle(writer, this.yappi.getParticle(name), "Particle: " + name + " not found.");
        } else if (request.getParameter("pdgid") != null) {
            PDGID pdgid = new PDGID(Integer.parseInt(request.getParameter("pdgid")));
            this.writeParticle(writer, this.yappi.getParticle(pdgid), "Particle with pdgid: " + pdgid + " not found.");
        } else if (request.getParameter("family") != null) {
            String family = request.getParameter("family");
            this.writeParticle(writer, null, "Family: " + family + " not found.");
        } else {
            writer.writeHead("Yappi lookup error.");
            writer.openTag("body");
            writer.openTag("h1");
            writer.println("Error, no particle, pdgid or family supplied.");
            writer.closeTag();
            writer.closeTag();
        }
        writer.close();
        out.close();
    }

    private void writeParticle(HTMLYappiWriter writer, ParticleType particle, String msg) {
        if (particle == null) {
            writer.writeHead(msg);
            writer.openTag("body");
            writer.openTag("h1");
            writer.println(msg);
            writer.closeTag();
            writer.closeTag();
        } else {
            writer.writeHead(particle.getName());
            writer.openTag("body");
            Family[] families = this.yappi.getFamilies(particle);
            for (int i = 0; i < families.length; ++i) {
                writer.write(families[i]);
            }
            writer.write(particle);
            writer.closeTag();
        }
    }
}

