/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi;

import hep.physics.yappi.Family;
import hep.physics.yappi.PDGID;
import hep.physics.yappi.ParticleType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class Yappi {
    private Map particlesByName = new HashMap();
    private Map particlesByPDGID = new HashMap();
    private Map families = new HashMap();

    public void addParticle(ParticleType particleType) {
        this.particlesByName.put(particleType.getName(), particleType);
        if (particleType.getPDGID() != null) {
            this.particlesByPDGID.put(particleType.getPDGID(), particleType);
        }
    }

    public Iterator getParticles() {
        return this.particlesByName.entrySet().iterator();
    }

    public ParticleType getParticle(String name) {
        return (ParticleType)this.particlesByName.get(name);
    }

    public ParticleType getParticle(PDGID pdgid) {
        return (ParticleType)this.particlesByPDGID.get(pdgid);
    }

    public Iterator getFamilies() {
        return this.families.entrySet().iterator();
    }

    public Family getFamily(String familyName) {
        return (Family)this.families.get(familyName);
    }

    public void addFamily(Family family) {
        this.families.put(family.getName(), family);
    }

    public void removeFamily(String familyName) {
        this.families.remove(familyName);
    }

    public void removeFamily(Family family) {
        this.removeFamily(family.getName());
    }

    public Family[] getFamilies(ParticleType particle) {
        Vector result = new Vector();
        Yappi.getFamilies(this.families.values().iterator(), particle, result);
        Object[] f = new Family[result.size()];
        result.copyInto(f);
        return f;
    }

    private static void getFamilies(Iterator familyIterator, ParticleType particle, Vector result) {
        while (familyIterator.hasNext()) {
            Family f = (Family)familyIterator.next();
            System.out.println(f);
            ParticleType p = f.getParticle(particle.getName());
            System.out.println(p);
            if (p != null) {
                result.addElement(f);
            }
            Yappi.getFamilies(f.getFamilies(), particle, result);
        }
    }
}

