/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi;

import hep.physics.yappi.Family;
import hep.physics.yappi.ParticleType;
import hep.physics.yappi.XMLYappiReader;
import hep.physics.yappi.XMLYappiWriter;
import hep.physics.yappi.Yappi;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;

public class XMLYappi
extends Yappi {
    boolean debug = false;

    public XMLYappi(String fileName) throws Exception {
        this.read(fileName);
    }

    public XMLYappi() {
    }

    private void println(String text) {
        if (this.debug) {
            System.out.println(text);
        }
    }

    private void print(String text) {
        if (this.debug) {
            System.out.print(text);
        }
    }

    public void read(String fileName) throws SAXException, IOException {
        XMLYappiReader xmlReader = new XMLYappiReader(this);
        xmlReader.read(fileName);
    }

    public void read(Reader reader) throws SAXException, IOException {
        XMLYappiReader xmlReader = new XMLYappiReader(this);
        xmlReader.read(reader);
    }

    public void write(String fileName) throws IOException {
        XMLYappiWriter xmlWriter = new XMLYappiWriter(fileName);
        xmlWriter.write(this);
    }

    public void displayFamilyTree() {
        XMLYappi.displayFamilyTree(this.getFamilies(), 0);
    }

    public static void displayFamilyTree(Iterator familyEntries, int indent) {
        while (familyEntries.hasNext()) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            Map.Entry familyEntry = (Map.Entry)familyEntries.next();
            Family family = (Family)familyEntry.getValue();
            System.out.println(family.getName());
            Iterator particleEntries = family.getParticles();
            while (particleEntries.hasNext()) {
                Map.Entry particleEntry = (Map.Entry)particleEntries.next();
                ParticleType particle = (ParticleType)particleEntry.getValue();
                for (int i = 0; i < indent; ++i) {
                    System.out.print(" ");
                }
                System.out.println(particle.getName());
            }
            XMLYappi.displayFamilyTree(family.getFamilies(), indent + 3);
        }
    }
}

