/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootObject;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TDatime;
import hep.io.root.interfaces.TKey;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Date;

public abstract class TKeyRep
extends AbstractRootObject
implements TKey {
    private AbstractRootObject object;
    private Date fDatime;
    private RootInput rin;
    private SoftReference soft;
    private String fClassName;
    private String fName;
    private String fTitle;
    private int fNbytes;
    private int fObjlen;
    private int fSeekKey;
    private int fSeekPdir;
    private short fCycle;
    private short fKeylen;

    public RootObject getObject() throws RootClassNotFound, IOException {
        if (this.object == null) {
            this.object = this.createObject(this.getObjectClass());
            this.rin.setPosition(this.fSeekKey + this.fKeylen);
            if (this.fObjlen > this.fNbytes - this.fKeylen) {
                RootInput in = this.getData();
                this.object.read(in);
            } else {
                this.rin.setMap(this.fKeylen);
                this.object.read(this.rin);
                this.rin.clearMap();
            }
            this.soft = new SoftReference<AbstractRootObject>(this.object);
        }
        return this.object;
    }

    public RootClass getObjectClass() throws RootClassNotFound, IOException {
        return this.rin.getFactory().create(this.fClassName);
    }

    public void readMembers(RootInput in) throws IOException {
        this.fNbytes = in.readInt();
        int v = in.readVersion();
        this.fObjlen = in.readInt();
        this.fDatime = ((TDatime)in.readObject("TDatime")).getDate();
        this.fKeylen = in.readShort();
        this.fCycle = in.readShort();
        this.fSeekKey = in.readInt();
        this.fSeekPdir = in.readInt();
        this.fClassName = in.readObject("TString").toString();
        this.fName = in.readObject("TString").toString();
        this.fTitle = in.readObject("TString").toString();
        this.rin = in.getTop();
    }

    RootInput getData() throws IOException {
        if (this.fNbytes - this.fKeylen < this.fObjlen) {
            RootInput slice = this.rin.slice(this.fNbytes - this.fKeylen, this.fObjlen);
            slice.setMap(this.fKeylen);
            return slice;
        }
        RootInput slice = this.rin.slice(this.fObjlen);
        slice.setMap(this.fKeylen);
        return slice;
    }

    private AbstractRootObject createObject(RootClass k) throws RootClassNotFound {
        return ((GenericRootClass)k).newInstance();
    }
}

