/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.NameMangler;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBasket;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TObjArray;
import java.io.IOException;
import java.util.HashMap;

public abstract class TBranchRep
extends AbstractRootObject
implements TBranch {
    private HashMap mangledMap;
    private HashMap map;
    private RootInput rin;
    private TBasket curBasket;
    private int curIndex;

    public TBranch getBranchForMangledName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (TBranch)this.mangledMap.get(name);
    }

    public TBranch getBranchForName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (TBranch)this.map.get(name);
    }

    public int getNEntries() {
        return (int)this.getEntries();
    }

    public RootInput setPosition(TLeaf leaf, int index) throws IOException {
        int i = this.findBasketForIndex(index);
        TBasket basket = this.getBasket(i);
        return basket.setPosition(index, this.getBasketEntry()[i], leaf);
    }

    public void read(RootInput in) throws IOException {
        super.read(in);
        this.rin = in.getTop();
        TObjArray leaves = this.getLeaves();
        if (leaves != null) {
            for (int i = 0; i < leaves.size(); ++i) {
                TLeaf leaf = (TLeaf)leaves.get(i);
                leaf.setBranch(this);
            }
        }
        this.curIndex = -1;
    }

    private TBasket getBasket(int index) throws IOException {
        try {
            if (index == this.curIndex) {
                return this.curBasket;
            }
            this.curIndex = index;
            TObjArray baskets = this.getBaskets();
            TBasket basket = (TBasket)baskets.get(index);
            if (basket != null) {
                this.curBasket = basket;
                return this.curBasket;
            }
            this.rin.setPosition(this.getBasketSeek()[index]);
            basket = (TBasket)this.rin.readObject("TBasket");
            int len = this.getEntryOffsetLen();
            if (len > 0) {
                basket.readEntryOffsets(len);
            }
            this.curBasket = basket;
            return this.curBasket;
        }
        catch (IOException x) {
            this.curIndex = -1;
            throw x;
        }
    }

    private void buildMap() {
        NameMangler nameMangler = NameMangler.instance();
        this.map = new HashMap();
        this.mangledMap = new HashMap();
        TObjArray branches = this.getBranches();
        int size = branches.size();
        for (int i = 0; i < size; ++i) {
            TBranch b = (TBranch)branches.get(i);
            String bName = b.getName();
            int pos = bName.indexOf(91);
            if (pos > 0) {
                bName = bName.substring(0, pos);
            }
            if ((pos = bName.lastIndexOf(46)) > 0) {
                bName = bName.substring(pos + 1);
            }
            this.map.put(bName, b);
            this.mangledMap.put(nameMangler.mangleMember(bName), b);
        }
    }

    private int findBasketForIndex(int index) {
        if (index < 0 || index >= this.getNEntries()) {
            throw new ArrayIndexOutOfBoundsException("index=" + index);
        }
        int[] entries = this.getBasketEntry();
        int n = this.getWriteBasket();
        for (int i = 0; i < n; ++i) {
            if (index < entries[i] || index >= entries[i + 1]) continue;
            return i;
        }
        return n;
    }
}

