/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.root;

import hep.aida.ITuple;
import hep.aida.ref.root.TLeafBColumn;
import hep.aida.ref.root.TLeafColumn;
import hep.aida.ref.root.TLeafDColumn;
import hep.aida.ref.root.TLeafFColumn;
import hep.aida.ref.root.TLeafIColumn;
import hep.aida.ref.tuple.AbstractTuple;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafD;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import hep.tuple.Cursor;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.freehep.util.Value;

class TLeafFolderColumn
extends TLeafColumn {
    private TLeafI dim;
    private TLeafColumn[] columns;
    private EmbeddedTuple embedded;

    TLeafFolderColumn(TLeafI dim) {
        this.dim = dim;
        this.embedded = new EmbeddedTuple(this.name());
    }

    /*
     * WARNING - void declaration
     */
    void addColumn(TLeaf leaf) {
        void var2_2;
        TLeafColumn col;
        if (leaf instanceof TLeafI) {
            col = new TLeafIColumn((TLeafI)leaf);
        } else if (leaf instanceof TLeafF) {
            col = new TLeafFColumn((TLeafF)leaf);
        } else if (leaf instanceof TLeafD) {
            col = new TLeafDColumn((TLeafD)leaf);
        } else if (leaf instanceof TLeafB) {
            col = new TLeafBColumn((TLeafB)leaf);
        } else {
            System.out.println("Ignored column " + leaf.getName() + " of type " + leaf.getClass());
            return;
        }
        if (this.columns == null) {
            this.columns = new TLeafColumn[]{var2_2};
        } else {
            ArrayList<TLeafColumn> x = new ArrayList<TLeafColumn>(Arrays.asList(this.columns));
            x.add((TLeafColumn)var2_2);
            this.columns = new TLeafColumn[x.size()];
            x.toArray(this.columns);
        }
    }

    void getValue(int row, Value value) {
        try {
            this.embedded.setGlobalRow(row);
            value.set((Object)this.embedded);
        }
        catch (IOException x) {
            x.printStackTrace();
            value.set((Object)null);
        }
    }

    public void defaultValue(Value value) {
        System.out.println("getting default value  " + this.name());
        value.set((Object)null);
    }

    public String name() {
        return "Folder[" + this.dim.getName() + "]";
    }

    public Class type() {
        return EmbeddedTuple.class;
    }

    void getArrayValue(int row, int dim, Value value) {
        throw new UnsupportedOperationException();
    }

    private class EmbeddedTuple
    extends AbstractTuple
    implements FTuple {
        private Cursor cursor;
        private Value theValue;
        private int nRows;
        private int theRow;

        EmbeddedTuple(String name) {
            super(name);
            this.theValue = new Value();
        }

        void setGlobalRow(int row) throws IOException {
            this.theRow = row;
            this.nRows = TLeafFolderColumn.this.dim.getValue(row);
            this.cursor = new Cursor(0, this.nRows, true);
        }

        public boolean getBoolean(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getBoolean();
        }

        public byte getByte(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getByte();
        }

        public char getChar(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getChar();
        }

        public double getDouble(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getDouble();
        }

        public float getFloat(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getFloat();
        }

        public boolean isInMemory() {
            return false;
        }

        public int getInt(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getInt();
        }

        public long getLong(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getLong();
        }

        public Object getObject(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getObject();
        }

        public void setRow(int row) throws IllegalArgumentException {
            this.cursor.setRow(row);
        }

        public short getShort(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getShort();
        }

        public String getString(int col) throws ClassCastException {
            TLeafFolderColumn.this.columns[col].getArrayValue(this.theRow, this.cursor.row(), this.theValue);
            return this.theValue.getString();
        }

        public ITuple getTuple(int param) {
            return null;
        }

        public void close() {
        }

        public FTupleColumn column(int index) {
            return TLeafFolderColumn.this.columns[index];
        }

        public FTupleColumn columnByName(String name) {
            int n = this.columnIndexByName(name);
            if (n < 0) {
                return null;
            }
            return this.column(n);
        }

        public int columnIndexByName(String name) {
            for (int i = 0; i < TLeafFolderColumn.this.columns.length; ++i) {
                if (!TLeafFolderColumn.this.columns[i].name().equals(name)) continue;
                return i;
            }
            return -1;
        }

        public double columnMax(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].maxValue(this.theValue);
            return this.theValue.getDouble();
        }

        public void columnMaxValue(int column, Value value) {
            value.set(this.columnMax(column));
        }

        public double columnMean(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].meanValue(this.theValue);
            return this.theValue.getDouble();
        }

        public void columnMeanValue(int column, Value value) {
            value.set(this.columnMean(column));
        }

        public double columnMin(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].minValue(this.theValue);
            return this.theValue.getDouble();
        }

        public void columnMinValue(int column, Value value) {
            value.set(this.columnMin(column));
        }

        public String columnName(int index) throws IllegalArgumentException {
            return TLeafFolderColumn.this.columns[index].name();
        }

        public String[] columnNames() throws IllegalArgumentException {
            String[] names = new String[TLeafFolderColumn.this.columns.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = TLeafFolderColumn.this.columns[i].name();
            }
            return names;
        }

        public double columnRms(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].rmsValue(this.theValue);
            return this.theValue.getDouble();
        }

        public void columnRmsValue(int column, Value value) {
            value.set(this.columnRms(column));
        }

        public Class columnType(int index) throws IllegalArgumentException {
            return TLeafFolderColumn.this.columns[index].type();
        }

        public Class[] columnTypes() throws IllegalArgumentException {
            Class[] types = new Class[TLeafFolderColumn.this.columns.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = TLeafFolderColumn.this.columns[i].type();
            }
            return types;
        }

        public void columnValue(int index, FTupleCursor cursor, Value value) {
            TLeafFolderColumn.this.columns[index].getArrayValue(this.theRow, cursor.row(), value);
        }

        public int columns() {
            return TLeafFolderColumn.this.columns.length;
        }

        public FTupleCursor cursor() throws IllegalStateException {
            return new Cursor(0, this.nRows, true);
        }

        public int findColumn(String name) throws IllegalArgumentException {
            int n = this.columnIndexByName(name);
            if (n < 0) {
                throw new IllegalArgumentException("Unknown column " + name);
            }
            return n;
        }

        public boolean next() {
            return this.cursor.next();
        }

        public int rows() {
            return this.nRows;
        }

        public void skip(int n) throws IllegalArgumentException {
            this.cursor.skip(n);
        }

        public void start() {
            this.cursor.start();
        }

        public boolean supportsMultipleCursors() {
            return true;
        }

        public boolean supportsRandomAccess() {
            return true;
        }

        public FTuple tuple(int index) {
            return null;
        }
    }
}

