/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.basic;

import hep.aida.IManagedObject;
import hep.aida.dev.IDevMutableStore;
import hep.aida.dev.IDevTree;
import hep.aida.ref.remote.basic.AidaUpdatable;
import hep.aida.ref.remote.basic.BasicAdapter;
import hep.aida.ref.remote.basic.UpdatableQueue;
import hep.aida.ref.remote.basic.interfaces.UpdateEvent;
import java.io.IOException;
import java.util.Map;

public abstract class BasicMutableStore
implements AidaUpdatable,
IDevMutableStore {
    protected IDevTree tree;
    protected UpdatableQueue queue;
    protected boolean hurry;

    public BasicMutableStore() {
        this(null, false);
    }

    public BasicMutableStore(boolean hurry) {
        this(null, hurry);
    }

    public BasicMutableStore(IDevTree tree, boolean hurry) {
        this.tree = tree;
        this.hurry = hurry;
        this.queue = new UpdatableQueue();
    }

    public IManagedObject createObject(String name, String type) {
        System.out.println("BasicMutableStore.createObject:  name=" + name + ",  type=" + type);
        return BasicAdapter.create(name, type);
    }

    public abstract void updateData(String var1, String var2);

    public void close() throws IOException {
        this.queue.close();
        this.tree = null;
    }

    public void commit(IDevTree tree, Map options) throws IOException {
        throw new UnsupportedOperationException("Can not commit changes to the Read-Only Store");
    }

    public boolean isReadOnly() {
        return true;
    }

    public abstract void read(IDevTree var1, String var2) throws IllegalArgumentException, IOException;

    public abstract void read(IDevTree var1, Map var2, boolean var3, boolean var4) throws IOException;

    public void stateChanged(UpdateEvent event) {
        int id = event.id();
        String path = event.path();
        String type = event.nodeType();
        if (id == 1) {
            System.out.println("Adding Node, path=" + event.path() + ",  type=" + type);
            if (type.equalsIgnoreCase("dir")) {
                try {
                    this.tree.mkdirs(path);
                }
                catch (IllegalArgumentException ex) {}
            } else {
                int index = path.lastIndexOf("/");
                String name = path.substring(index + 1);
                String objDir = path.substring(0, index + 1);
                IManagedObject h = null;
                try {
                    h = this.tree.find(path);
                }
                catch (IllegalArgumentException exFind) {
                    // empty catch block
                }
                if (h != null) {
                    return;
                }
                try {
                    this.tree.mkdirs(objDir);
                }
                catch (IllegalArgumentException exObj) {
                    // empty catch block
                }
                System.out.println("\tCreating ManagedObject with name: " + name + ",  path: " + objDir + ",  type=" + type);
                h = this.createObject(name, type);
                this.tree.add(objDir, h);
                this.updateData(path, type);
            }
        } else if (id == 2) {
            System.out.println("Deleting Node, path=" + event.path() + ",  type=" + type);
            if (type.equalsIgnoreCase("dir")) {
                try {
                    String[] list = this.tree.listObjectNames(path);
                    this.tree.rmdir(path);
                }
                catch (IllegalArgumentException ex) {}
            } else {
                try {
                    IManagedObject obj = this.tree.find(path);
                    this.tree.rm(path);
                }
                catch (IllegalArgumentException ex) {}
            }
        } else if (id == 0) {
            System.out.println("Updating Node, path=" + event.path() + ",  type=" + type);
            this.updateData(path, type);
        } else {
            System.out.println("Wrong ID=" + event.id() + ", path=" + event.path() + ",  type=" + type);
        }
    }

    public static void main(String[] args) {
    }
}

