/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.IsObservable;

public abstract class RemoteManagedObject
extends ManagedObject
implements IsObservable {
    protected IDevMutableStore store = null;
    protected String treePath = null;
    protected String aidaType = "IManagedObject";
    protected boolean dataIsValid = false;

    public RemoteManagedObject(String name) {
        super(name);
        this.fillable = false;
    }

    protected void makeSureDataIsValid() {
        if (this.dataIsValid || this.fillable) {
            return;
        }
        this.store.updateData(this.treePath, this.aidaType);
    }

    public void setStore(IDevMutableStore store) {
        this.store = store;
    }

    public void setTreeFolder(String treeFolder) {
        String histName = this.name() == null ? "" : this.name();
        this.treePath = treeFolder.equals("/") && histName.startsWith("/") ? histName : treeFolder + "/" + histName;
    }

    public void setDataValid(boolean dataIsValid) {
        if (this.dataIsValid != dataIsValid) {
            this.dataIsValid = dataIsValid;
            if (this.isValid) {
                this.fireStateChanged();
            }
        }
    }

    public boolean isDataValid() {
        return this.dataIsValid;
    }
}

