/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IMeasurement;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.remote.RemoteManagedObject;

public class RemoteDataPointSet
extends RemoteManagedObject
implements IDataPointSet {
    protected Annotation annotation = null;
    protected int dimension;
    protected double[] upperExtent;
    protected double[] lowerExtent;
    protected double[] values;
    protected double[] plusErrors;
    protected double[] minusErrors;

    public RemoteDataPointSet(String name) {
        this(null, name);
    }

    public RemoteDataPointSet(IDevMutableStore store, String name) {
        this(store, name, name, 0);
    }

    public RemoteDataPointSet(IDevMutableStore store, String name, String title, int dimOfPoint) {
        super(name);
        this.aidaType = "IDataPointSet";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, name, true);
        this.annotation.setFillable(false);
        this.init(dimOfPoint);
    }

    protected void init(int dimOfPoint) {
        this.dimension = dimOfPoint;
        this.upperExtent = new double[this.dimension];
        this.lowerExtent = new double[this.dimension];
        this.dataIsValid = false;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void setPlusErrors(double[] plusErrors) {
        this.plusErrors = plusErrors;
    }

    public void setMinusErrors(double[] minusErrors) {
        this.minusErrors = minusErrors;
    }

    public void setUpperExtent(double[] upperExtent) {
        this.upperExtent = upperExtent;
    }

    public void setLowerExtent(double[] lowerExtent) {
        this.lowerExtent = lowerExtent;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void print() {
        System.out.println("\nRemoteDataPointSet  name=" + this.name() + ", title=" + this.title() + ", dimension=" + this.dimension() + ", size=" + this.size());
        for (int dim = 0; dim < this.dimension(); ++dim) {
            System.out.println("\tDimension=" + dim + "  lowerExtent=" + this.lowerExtent(dim) + "  upperExtent=" + this.upperExtent(dim));
        }
        for (int ip = 0; ip < this.size(); ++ip) {
            IDataPoint p = this.point(ip);
            System.out.print("\n\t" + ip);
            for (int dim = 0; dim < this.dimension(); ++dim) {
                IMeasurement m = p.coordinate(dim);
                System.out.print("  dim=" + dim + "  v=" + m.value() + " er=" + m.errorPlus() + " em=" + m.errorMinus() + "; ");
            }
        }
        System.out.print("\n\n");
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.annotation;
    }

    public int dimension() {
        this.makeSureDataIsValid();
        return this.dimension;
    }

    public int size() {
        this.makeSureDataIsValid();
        if (this.values == null || this.dimension() == 0) {
            return 0;
        }
        return this.values.length / this.dimension();
    }

    public void setTitle(String title) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.annotation.setFillable(true);
        this.annotation.setValue(Annotation.titleKey, title);
        this.annotation.setFillable(false);
    }

    public String title() {
        this.makeSureDataIsValid();
        return this.annotation.value(Annotation.titleKey);
    }

    public double upperExtent(int coordinate) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.upperExtent == null || this.dimension() == 0 || this.size() == 0) {
            return Double.NaN;
        }
        return this.upperExtent[coordinate];
    }

    public double lowerExtent(int coordinate) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.lowerExtent == null || this.dimension() == 0 || this.size() == 0) {
            return Double.NaN;
        }
        return this.lowerExtent[coordinate];
    }

    public IDataPoint point(int index) {
        this.makeSureDataIsValid();
        return new RemoteDataPoint(index);
    }

    public void removePoint(int index) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void clear() {
        throw new ReadOnlyException();
    }

    public IDataPoint addPoint() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void addPoint(IDataPoint iDataPoint) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void scaleErrors(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void scaleValues(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void setCoordinate(int param, double[] values, double[] values2) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void setCoordinate(int param, double[] values, double[] values2, double[] values3) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public class RemoteMeasurement
    implements IMeasurement {
        private int index;

        public RemoteMeasurement(int index) {
            this.index = index;
        }

        public double value() {
            if (RemoteDataPointSet.this.values == null) {
                return Double.NaN;
            }
            return RemoteDataPointSet.this.values[this.index];
        }

        public double errorMinus() {
            if (RemoteDataPointSet.this.plusErrors == null) {
                return Double.NaN;
            }
            return RemoteDataPointSet.this.plusErrors[this.index];
        }

        public double errorPlus() {
            if (RemoteDataPointSet.this.minusErrors == null) {
                return Double.NaN;
            }
            return RemoteDataPointSet.this.minusErrors[this.index];
        }

        public void setErrorMinus(double param) throws IllegalArgumentException {
            throw new ReadOnlyException();
        }

        public void setErrorPlus(double param) throws IllegalArgumentException {
            throw new ReadOnlyException();
        }

        public void setValue(double param) throws IllegalArgumentException {
            throw new ReadOnlyException();
        }
    }

    public class RemoteDataPoint
    implements IDataPoint {
        private int startIndex;
        private int stopIndex;

        public RemoteDataPoint(int index) {
            this.startIndex = RemoteDataPointSet.this.dimension * index;
            this.stopIndex = this.startIndex + RemoteDataPointSet.this.dimension - 1;
        }

        public IMeasurement coordinate(int param) {
            if (param < 0 || param >= RemoteDataPointSet.this.dimension) {
                throw new IllegalArgumentException("Not valid value of coordinate index: " + param);
            }
            return new RemoteMeasurement(this.startIndex + param);
        }

        public int dimension() {
            return RemoteDataPointSet.this.dimension;
        }
    }
}

