/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IProfile;
import hep.aida.IProfile1D;
import hep.aida.ref.plotter.adapter.AIDAProfileAdapter;
import hep.aida.ref.plotter.adapter.AIDAProfileStatistics1D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;

class AIDAProfileAdapter1D
extends AIDAProfileAdapter
implements Rebinnable1DHistogramData,
HasStatistics {
    private IProfile1D profile;

    AIDAProfileAdapter1D(IProfile1D profile) {
        super((IProfile)profile);
        this.profile = profile;
    }

    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        this.setValid();
        double[][] data = new double[2][this.profile.axis().bins()];
        for (int i = 0; i < this.profile.axis().bins(); ++i) {
            data[0][i] = this.profile.binHeight(i);
            if (Double.isInfinite(data[0][i])) {
                data[0][i] = Double.NaN;
            }
            data[1][i] = this.profile.binRms(i);
        }
        return data;
    }

    public double getMin() {
        return this.profile.axis().lowerEdge();
    }

    public double getMax() {
        return this.profile.axis().upperEdge();
    }

    public int getBins() {
        return this.profile.axis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public int getAxisType() {
        return 1;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.profile.title();
    }

    public Statistics getStatistics() {
        return new AIDAProfileStatistics1D(this.profile);
    }
}

