/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IHistogram2D;
import jas.hist.ExtendedStatistics;

class AIDAHistogramStatistics2D
implements ExtendedStatistics {
    private IHistogram2D histo;
    private String[] statNames = new String[]{"Entries", "OutOfRange", "XMean", "XRms", "YMean", "YRms"};

    AIDAHistogramStatistics2D(IHistogram2D histo) {
        this.histo = histo;
    }

    public String[] getStatisticNames() {
        return this.statNames;
    }

    public double getStatistic(String name) {
        if (name.equals("XMean")) {
            return this.histo.meanX();
        }
        if (name.equals("XRms")) {
            return this.histo.rmsX();
        }
        if (name.equals("YMean")) {
            return this.histo.meanY();
        }
        if (name.equals("YRms")) {
            return this.histo.rmsY();
        }
        return 0.0;
    }

    public Object getExtendedStatistic(String name) {
        if (name.equals("Entries")) {
            return new Integer(this.histo.entries());
        }
        if (name.equals("OutOfRange")) {
            return new Integer(this.histo.extraEntries());
        }
        return null;
    }
}

