/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter;
import hep.aida.ref.plotter.adapter.AIDAHistogramStatistics1D;
import jas.hist.HasStatistics;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;

public class AIDAHistogramAdapter1D
extends AIDAHistogramAdapter
implements Rebinnable1DHistogramData,
HasStatistics {
    private int axisType = 1;
    private IHistogram1D histo;

    AIDAHistogramAdapter1D(IHistogram1D histo) {
        super((IHistogram)histo);
        this.histo = histo;
    }

    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        this.setValid();
        double[][] data = new double[2][this.histo.axis().bins()];
        for (int i = 0; i < this.histo.axis().bins(); ++i) {
            data[0][i] = this.histo.binHeight(i);
            if (Double.isInfinite(data[0][i])) {
                data[0][i] = Double.NaN;
            }
            data[1][i] = this.histo.binError(i);
        }
        return data;
    }

    public double getMin() {
        return this.histo.axis().lowerEdge();
    }

    public double getMax() {
        return this.histo.axis().upperEdge();
    }

    public int getBins() {
        return this.histo.axis().bins();
    }

    public boolean isRebinnable() {
        return false;
    }

    public void setAxisType(int type) {
        this.axisType = type;
    }

    public int getAxisType() {
        return this.axisType;
    }

    public String[] getAxisLabels() {
        return null;
    }

    public String getTitle() {
        return this.histo.title();
    }

    public Statistics getStatistics() {
        return new AIDAHistogramStatistics1D(this.histo);
    }
}

