/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import jas.hist.DataSource;
import jas.hist.ExtendedStatistics;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.Statistics;
import jas.hist.XYDataSource;

public class AIDADataPointSetAdapter
implements XYDataSource,
HasStatistics,
HasStyle {
    private int axisType = 1;
    private JASHist1DHistogramStyle style;
    private IDataPointSet dpSet;
    private AIDADataPointSetStatistics st;
    private double[] x;
    private double[] y;
    private double[] ep;
    private double[] em;

    public static DataSource create(IDataPointSet dps) {
        if (dps instanceof DataSource) {
            return (DataSource)dps;
        }
        if (dps.dimension() >= 3 || dps.dimension() <= 0) {
            throw new IllegalArgumentException("Cannot diplay DataPointSets with dimension grater than 2.");
        }
        AIDADataPointSetAdapter result = new AIDADataPointSetAdapter(dps);
        return result;
    }

    protected AIDADataPointSetAdapter(IDataPointSet dps) {
        this.dpSet = dps;
        this.st = new AIDADataPointSetStatistics(this.dpSet);
        this.style = new JASHist1DHistogramStyle();
        this.style.setShowHistogramBars(false);
        this.style.setShowDataPoints(true);
        this.style.setErrorBarColor(this.style.getDataPointColor());
        int dim = this.dpSet.dimension();
        int size = this.dpSet.size();
        this.x = new double[size];
        this.y = new double[size];
        this.ep = new double[size];
        this.em = new double[size];
        for (int i = 0; i < size; ++i) {
            IDataPoint p = this.dpSet.point(i);
            this.em[i] = p.coordinate(dim - 1).errorMinus();
            this.ep[i] = p.coordinate(dim - 1).errorPlus();
            this.y[i] = p.coordinate(dim - 1).value();
            this.x[i] = dim == 2 ? p.coordinate(0).value() : (double)i;
        }
    }

    public void setAxisType(int type) {
        this.axisType = type;
    }

    public int getAxisType() {
        return this.axisType;
    }

    public double getMinusError(int i) {
        return this.em[i];
    }

    public double getPlusError(int i) {
        return this.ep[i];
    }

    public double getX(int i) {
        return this.x[i];
    }

    public double getY(int i) {
        return this.y[i];
    }

    public int getNPoints() {
        return this.dpSet.size();
    }

    public Statistics getStatistics() {
        return this.st;
    }

    public String getTitle() {
        return this.dpSet.title();
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    class AIDADataPointSetStatistics
    implements ExtendedStatistics {
        private IDataPointSet dps;
        private final String[] statNames = new String[]{"Entries"};

        AIDADataPointSetStatistics(IDataPointSet dps) {
            this.dps = dps;
        }

        public double getStatistic(String str) {
            if (str.equals("Entries")) {
                return this.dps.size();
            }
            return 0.0;
        }

        public String[] getStatisticNames() {
            return this.statNames;
        }

        public Object getExtendedStatistic(String name) {
            return null;
        }
    }
}

