/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBaseStyle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BaseStyle
implements IBaseStyle {
    private ArrayList parameters = new ArrayList();
    private ArrayList parOptions = new ArrayList();
    private ArrayList parValues = new ArrayList();
    private ArrayList parDefaults = new ArrayList();
    private Hashtable baseStyles = new Hashtable();
    private BaseStyle parent = null;
    private String[] noOptions = new String[0];
    private String name = "plotter";

    protected BaseStyle() {
        this(null);
    }

    protected BaseStyle(BaseStyle parent) {
        this.initializeBaseStyle();
        this.setParent(parent);
    }

    protected abstract void initializeBaseStyle();

    protected void setName(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    public void setParent(IBaseStyle p) {
        BaseStyle parent;
        this.parent = parent = (BaseStyle)p;
        if (parent != null) {
            Enumeration keys = this.baseStyles.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                this.baseStyle(name).setParent(parent.baseStyle(name));
            }
        }
    }

    public BaseStyle parent() {
        return this.parent;
    }

    protected void addBaseStyle(IBaseStyle baseStyle, String name) {
        BaseStyle bs = (BaseStyle)baseStyle;
        bs.setName(name);
        this.baseStyles.put(bs.name(), baseStyle);
        if (this.parent != null) {
            bs.setParent(this.parent.baseStyle(bs.name()));
        }
    }

    private BaseStyle baseStyle(String name) {
        return (BaseStyle)this.baseStyles.get(name);
    }

    protected void addParameter(String parameterName) {
        this.addParameter(parameterName, null, null);
    }

    protected void addParameter(String parameterName, String defaultValue) {
        this.addParameter(parameterName, null, defaultValue);
    }

    protected void addParameter(String parameterName, String[] options) {
        this.addParameter(parameterName, options, null);
    }

    protected void addParameter(String parameterName, String[] options, String defaultValue) {
        try {
            this.parameterIndex(parameterName);
            throw new IllegalArgumentException("Parameter " + parameterName + " already belongs to this BaseStyle");
        }
        catch (IllegalArgumentException iae) {
            this.parameters.add(parameterName);
            this.parOptions.add(options);
            this.parDefaults.add(defaultValue);
            this.parValues.add(null);
            return;
        }
    }

    private int parameterIndex(String parameterName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!((String)this.parameters.get(i)).toLowerCase().equals(parameterName.toLowerCase())) continue;
            return i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " is not part of this Style.");
    }

    private String parameterValue(int parIndex) {
        Object obj = this.parValues.get(parIndex);
        if (obj != null) {
            return (String)obj;
        }
        if (this.parent() == null) {
            return this.parameterDefaultValue(parIndex);
        }
        return this.parent().parameterValue(parIndex);
    }

    protected String parameterDefaultValue(String parameterName) {
        return (String)this.parDefaults.get(this.parameterIndex(parameterName));
    }

    protected String parameterDefaultValue(int parIndex) {
        return (String)this.parDefaults.get(parIndex);
    }

    public String[] availableParameterOptions(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        Object obj = this.parOptions.get(parIndex);
        return obj == null ? this.noOptions : (String[])obj;
    }

    public String[] availableParameters() {
        int size = this.parameters.size();
        String[] pars = new String[size];
        for (int i = 0; i < size; ++i) {
            pars[i] = (String)this.parameters.get(i);
        }
        return pars;
    }

    public String parameterValue(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        return this.parameterValue(parIndex);
    }

    public void reset() {
        this.parValues.clear();
        Enumeration keys = this.baseStyles.keys();
        while (keys.hasMoreElements()) {
            this.baseStyle((String)keys.nextElement()).reset();
        }
    }

    public boolean setParameter(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        this.parValues.set(parIndex, null);
        return true;
    }

    public boolean setParameter(String parameterName, String parValue) {
        int parIndex = this.parameterIndex(parameterName);
        this.parValues.set(parIndex, parValue);
        return true;
    }
}

