/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.uncmin;

import hep.aida.IFunction;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.optimizer.AbstractOptimizer;
import hep.aida.ref.optimizer.OptimizerResult;
import hep.aida.ref.optimizer.uncmin.Matrix;
import hep.aida.ref.optimizer.uncmin.UncminOptimizerConfiguration;
import optimization.Uncmin_f77;
import optimization.Uncmin_methods;

public class UncminOptimizer
extends AbstractOptimizer {
    int[] varIndex;

    public UncminOptimizer() {
        this.result = new OptimizerResult();
        this.configuration = new UncminOptimizerConfiguration();
        this.domainConstraint = null;
    }

    public void optimize() {
        double tolerance;
        if (this.function == null) {
            throw new IllegalArgumentException("Cannot optimize!! The function was not set correctely!");
        }
        String[] variableNames = this.function.variableNames();
        this.varIndex = new int[variableNames.length];
        if (variableNames == null || variableNames.length == 0) {
            throw new IllegalArgumentException("Cannot optimize!! There are no variables in this function!");
        }
        int dimension = 0;
        for (int i = 0; i < variableNames.length; ++i) {
            String varName = variableNames[i];
            IVariableSettings varSet = this.variableSettings(varName);
            if (varSet.isFixed()) continue;
            this.varIndex[dimension] = i;
            ++dimension;
        }
        if (dimension == 0) {
            throw new IllegalArgumentException("There are no free variables!!");
        }
        UncminFunc uncminFunc = new UncminFunc(this.function, dimension, this);
        String method = this.configuration.method();
        int strategy = this.configuration.strategy();
        double[] xIn = new double[dimension + 1];
        double[] stepSize = new double[dimension + 1];
        double[] fscale = new double[2];
        int[] methodIndex = new int[2];
        int[] strategyIndex = new int[2];
        int[] performChecks = new int[2];
        int[] ndigit = new int[2];
        int[] maxIter = new int[2];
        int[] useGradient = new int[2];
        int[] useHessian = new int[2];
        double[] trustRegionRadius = new double[2];
        double[] gradientTol = new double[2];
        double[] stepTol = new double[2];
        double[] stepMax = new double[2];
        double[] xOut = new double[dimension + 1];
        double[] fOut = new double[2];
        double[] gradientOut = new double[dimension + 1];
        double[][] hessianOut = new double[dimension + 1][dimension + 1];
        double[] hessianDiagOut = new double[dimension + 1];
        int[] terminationCode = new int[2];
        fscale[1] = 1.0;
        ndigit[1] = -1;
        trustRegionRadius[1] = -1.0;
        stepMax[1] = 0.0;
        method.toUpperCase();
        if (method.startsWith("LIN")) {
            methodIndex[1] = 1;
        } else if (method.startsWith("DOU")) {
            methodIndex[1] = 2;
        } else if (method.startsWith("MOR")) {
            methodIndex[1] = 3;
        }
        switch (strategy) {
            case 0: {
                strategyIndex[1] = 1;
                performChecks[1] = 0;
                break;
            }
            case 1: {
                strategyIndex[1] = 0;
                performChecks[1] = 0;
                break;
            }
            case 2: {
                strategyIndex[1] = 1;
                performChecks[1] = 1;
                break;
            }
            case 3: {
                strategyIndex[1] = 0;
                performChecks[1] = 1;
            }
        }
        maxIter[1] = this.configuration.maxIterations();
        if (this.configuration.useFunctionGradient()) {
            useGradient[1] = 1;
        }
        if (this.configuration.useFunctionHessian()) {
            useHessian[1] = 1;
        }
        gradientTol[1] = tolerance = this.configuration.tolerance();
        stepTol[1] = tolerance;
        for (int i = 0; i < dimension; ++i) {
            String varName = variableNames[this.varIndex(i)];
            IVariableSettings varSet = this.variableSettings(varName);
            xIn[i + 1] = varSet.value();
            stepSize[i + 1] = varSet.stepSize();
        }
        Uncmin_f77.optif9_f77((int)dimension, (double[])xIn, (Uncmin_methods)uncminFunc, (double[])stepSize, (double[])fscale, (int[])methodIndex, (int[])strategyIndex, (int[])performChecks, (int[])ndigit, (int[])maxIter, (int[])useGradient, (int[])useHessian, (double[])trustRegionRadius, (double[])gradientTol, (double[])stepMax, (double[])stepTol, (double[])xOut, (double[])fOut, (double[])gradientOut, (int[])terminationCode, (double[][])hessianOut, (double[])hessianDiagOut);
        switch (terminationCode[1]) {
            case 0: {
                this.result.setOptimizationStatus(3);
                break;
            }
            case 1: {
                this.result.setOptimizationStatus(4);
                break;
            }
            case 2: {
                this.result.setOptimizationStatus(5);
                break;
            }
            case 3: {
                this.result.setOptimizationStatus(6);
                break;
            }
            case 4: {
                this.result.setOptimizationStatus(7);
                break;
            }
            case 5: {
                this.result.setOptimizationStatus(8);
            }
        }
        int outCount = 0;
        for (int i = 0; i < variableNames.length; ++i) {
            String varName = variableNames[i];
            IVariableSettings varSet = this.variableSettings(varName);
            if (varSet.isFixed()) continue;
            double val = xOut[outCount + 1];
            double err = Math.sqrt(2.0 / hessianDiagOut[outCount + 1]);
            varSet.setValue(val);
            varSet.setStepSize(err);
            ++outCount;
        }
        double[][] covMatrix = new double[dimension][dimension];
        for (int i = 0; i < dimension; ++i) {
            for (int j = i; j < dimension; ++j) {
                if (i == j) {
                    covMatrix[i][i] = hessianDiagOut[i + 1] / 2.0;
                    continue;
                }
                covMatrix[i][j] = hessianOut[i + 1][j + 1] / 2.0;
                covMatrix[j][i] = hessianOut[i + 1][j + 1] / 2.0;
            }
        }
        Matrix.invert(covMatrix);
        this.result.setCovarianceMatrix(covMatrix);
    }

    private int varIndex(int index) {
        return this.varIndex[index];
    }

    private class UncminFunc
    implements Uncmin_methods {
        IFunction function;
        UncminOptimizer optimizer;
        int dimension;
        double[] vars;

        UncminFunc(IFunction function, int dimension, UncminOptimizer optimizer) {
            this.dimension = dimension;
            this.function = function;
            this.optimizer = optimizer;
            String[] variableNames = function.variableNames();
            this.vars = new double[variableNames.length];
            for (int i = 0; i < variableNames.length; ++i) {
                this.vars[i] = optimizer.variableSettings(variableNames[i]).value();
            }
        }

        public double f_to_minimize(double[] x) {
            for (int i = 0; i < this.dimension; ++i) {
                this.vars[((UncminOptimizer)this.optimizer).varIndex((int)i)] = x[i + 1];
            }
            return this.function.value(this.vars);
        }

        public void gradient(double[] x, double[] g) {
            g = this.function.gradient(x);
        }

        public void hessian(double[] x, double[][] h) {
            throw new UnsupportedOperationException("Cannot calculate function's Hessian. Please report this problem");
        }

        private int indexOf(int index) {
            return UncminOptimizer.this.varIndex[index];
        }
    }
}

