/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.fmin;

import hep.aida.IFunction;
import hep.aida.ext.IVariable;
import hep.aida.ref.function.AbstractModelFunction;
import hep.aida.ref.function.Variable;
import hep.aida.ref.optimizer.AbstractOptimizer;
import hep.aida.ref.optimizer.OptimizerResult;
import hep.aida.ref.optimizer.fmin.FminOptimizerConfiguration;
import optimization.Fmin;
import optimization.Fmin_methods;

public class FminOptimizer
extends AbstractOptimizer {
    public FminOptimizer() {
        this.result = new OptimizerResult();
        this.configuration = new FminOptimizerConfiguration();
        this.domainConstraint = null;
    }

    public void optimize() {
        if (this.function == null) {
            throw new IllegalArgumentException("Cannot optimize!! The function was not set correctely!");
        }
        String method = this.configuration.method();
        if (method.equals("FMIN")) {
            IVariable[] vars = ((AbstractModelFunction)this.function).variables();
            Variable var = null;
            for (int i = 0; i < vars.length; ++i) {
                if (vars[i].isFixed()) continue;
                if (var != null) {
                    throw new IllegalArgumentException("Problem in Fmin optimize!! With method " + method + " it is only possible to performe 1-d optimization!!");
                }
                var = (Variable)vars[i];
            }
            if (var == null) {
                throw new IllegalArgumentException("Problem in Fmin optimize!! There are no free variables to optimize");
            }
            if (var.nRanges() > 1) {
                throw new IllegalArgumentException("Problem in Fmin optimize!! Variable " + var.name() + " can only have a single range!!");
            }
            double lb = var.getRange(0).lowerBound();
            double ub = var.getRange(0).upperBound();
            FminFunc func = new FminFunc(this.function, var);
            double xmin = Fmin.fmin((double)lb, (double)ub, (Fmin_methods)func, (double)this.configuration.tolerance());
        }
    }

    private class FminFunc
    implements Fmin_methods {
        protected IFunction func;
        protected IVariable var;

        FminFunc(IFunction func, IVariable var) {
            this.func = func;
            this.var = var;
        }

        public double f_to_minimize(double x) {
            this.var.setValue(x);
            return ((AbstractModelFunction)this.func).value();
        }
    }
}

