/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IMeasurement;

public class Measurement
implements IMeasurement {
    private double value;
    private double errorPlus;
    private double errorMinus;

    public Measurement() {
        this.value = Double.NaN;
        this.errorPlus = Double.NaN;
        this.errorMinus = Double.NaN;
    }

    public Measurement(IMeasurement m) {
        this.value = m.value();
        this.errorPlus = m.errorPlus();
        this.errorMinus = m.errorMinus();
    }

    public Measurement(double val) {
        this.value = val;
        this.errorPlus = Double.NaN;
        this.errorMinus = Double.NaN;
    }

    public Measurement(double val, double err) {
        this.value = val;
        this.errorPlus = err;
        this.errorMinus = err;
    }

    public Measurement(double val, double errMinus, double errPlus) {
        this.value = val;
        this.errorPlus = errMinus;
        this.errorMinus = errPlus;
    }

    public double value() {
        return this.value;
    }

    public double errorPlus() {
        if (Double.isNaN(this.errorPlus)) {
            return 0.0;
        }
        return this.errorPlus;
    }

    public double errorMinus() {
        if (Double.isNaN(this.errorMinus)) {
            return this.errorPlus();
        }
        return this.errorMinus;
    }

    public void setValue(double value) throws IllegalArgumentException {
        this.value = value;
    }

    public void setErrorPlus(double errorPlus) throws IllegalArgumentException {
        if (errorPlus < 0.0) {
            throw new IllegalArgumentException("Attempt to set negative value for \"errorPlus\" in Measurement");
        }
        this.errorPlus = errorPlus;
    }

    public void setErrorMinus(double errorMinus) throws IllegalArgumentException {
        if (errorMinus < 0.0) {
            throw new IllegalArgumentException("Attempt to set negative value for \"errorMinus\" in Measurement");
        }
        this.errorMinus = errorMinus;
    }
}

