/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAnnotation;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IMeasurement;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.DataPointSetEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.DataPoint;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class DataPointSet
extends ManagedObject
implements IDataPointSet,
IsObservable {
    private int defaultSize = 0;
    private IAnnotation annotation;
    private int dimension;
    private List points;

    protected DataPointSet() {
        super("");
        this.initDataPointSet();
        this.annotation.addItem(Annotation.titleKey, "Title", true);
    }

    public DataPointSet(String name, String title, int dimOfPoints) {
        this(name, title, dimOfPoints, 0);
    }

    public DataPointSet(String name, String title, int dimOfPoints, int defaultCapacity) {
        super(name);
        this.defaultSize = defaultCapacity;
        this.dimension = dimOfPoints;
        this.initDataPointSet();
        this.annotation.addItem(Annotation.titleKey, title, true);
    }

    private void initDataPointSet() {
        this.annotation = new Annotation();
        this.points = new ArrayList(this.defaultSize);
        for (int i = 0; i < this.defaultSize; ++i) {
            this.points.add(new DataPoint(this.dimension));
        }
    }

    protected EventObject createEvent() {
        return new DataPointSetEvent(this);
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public void setAnnotation(IAnnotation annotation) {
        this.annotation = annotation;
    }

    public String title() {
        return this.annotation.value(Annotation.titleKey);
    }

    public void setTitle(String title) throws IllegalArgumentException {
        this.annotation.setValue(Annotation.titleKey, title);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public int dimension() {
        return this.dimension;
    }

    public void clear() {
        this.points = new ArrayList(this.defaultSize);
    }

    public int size() {
        return this.points.size();
    }

    public IDataPoint point(int index) {
        return (IDataPoint)this.points.get(index);
    }

    public void setPoint(int index, IDataPoint point) throws IllegalArgumentException {
        if (index >= this.points.size() || index < 0) {
            throw new IllegalArgumentException("Wrong argument in setPoint():  index=" + index + ", size=" + this.points.size());
        }
        this.points.set(index, point);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public IDataPoint addPoint() throws RuntimeException {
        DataPoint point = new DataPoint(this.dimension);
        this.points.add(point);
        if (this.isValid) {
            this.fireStateChanged();
        }
        return point;
    }

    public void addPoint(IDataPoint point) throws IllegalArgumentException {
        if (point.dimension() != this.dimension) {
            throw new IllegalArgumentException("Wrong dimension in addPoint(): DataPointSet.dimension()=" + this.dimension + ", DataPoint.dimension()=" + point.dimension());
        }
        this.points.add(point);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void removePoint(int index) throws IllegalArgumentException {
        if (index >= this.points.size() || index < 0) {
            throw new IllegalArgumentException("Wrong argument in removePoint()  index=" + index + ", size=" + this.points.size());
        }
        this.points.remove(index);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double lowerExtent(int coord) throws IllegalArgumentException {
        if (coord < 0 || coord >= this.dimension || this.points.size() == 0) {
            throw new IllegalArgumentException("Can not calculate lowerExtent: coord=" + coord + ", size=" + this.points.size());
        }
        double lowerExtent = Double.NaN;
        for (int i = 0; i < this.points.size(); ++i) {
            double lower = ((DataPoint)this.points.get(i)).lowerExtent(coord);
            if (!Double.isNaN(lowerExtent) && !(lowerExtent > lower)) continue;
            lowerExtent = lower;
        }
        return lowerExtent;
    }

    public double upperExtent(int coord) throws IllegalArgumentException {
        if (coord < 0 || coord >= this.dimension || this.points.size() == 0) {
            throw new IllegalArgumentException("Can not calculate upperExtent: coord=" + coord + ", size=" + this.points.size());
        }
        double upperExtent = Double.NaN;
        for (int i = 0; i < this.points.size(); ++i) {
            double upper = ((DataPoint)this.points.get(i)).upperExtent(coord);
            if (!Double.isNaN(upperExtent) && !(upper > upperExtent)) continue;
            upperExtent = upper;
        }
        return upperExtent;
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor: scaleFactor=" + scaleFactor);
        }
        for (int i = 0; i < this.points.size(); ++i) {
            IDataPoint p = (IDataPoint)this.points.get(i);
            for (int j = 0; j < this.dimension; ++j) {
                IMeasurement meas = p.coordinate(j);
                meas.setValue(meas.value() * scaleFactor);
                meas.setErrorMinus(meas.errorMinus() * scaleFactor);
                meas.setErrorPlus(meas.errorPlus() * scaleFactor);
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void scaleValues(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor: scaleFactor=" + scaleFactor);
        }
        for (int i = 0; i < this.points.size(); ++i) {
            IDataPoint p = (IDataPoint)this.points.get(i);
            for (int j = 0; j < this.dimension; ++j) {
                IMeasurement meas = p.coordinate(j);
                meas.setValue(meas.value() * scaleFactor);
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void scaleErrors(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor: scaleFactor=" + scaleFactor);
        }
        for (int i = 0; i < this.points.size(); ++i) {
            IDataPoint p = (IDataPoint)this.points.get(i);
            for (int j = 0; j < this.dimension; ++j) {
                IMeasurement meas = p.coordinate(j);
                meas.setErrorMinus(meas.errorMinus() * scaleFactor);
                meas.setErrorPlus(meas.errorPlus() * scaleFactor);
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void setCoordinate(int coord, double[] values, double[] errors) throws IllegalArgumentException {
        this.setCoordinate(coord, values, errors, errors);
    }

    public void setCoordinate(int coord, double[] values, double[] errp, double[] errm) throws IllegalArgumentException {
        if (coord < 0 || coord >= this.dimension()) {
            throw new IllegalArgumentException("Illegal coordinate " + coord + "!! It has to be 0 <= coord < " + this.dimension());
        }
        int nPoints = values.length;
        if (nPoints != errp.length) {
            throw new IllegalArgumentException("Incompatible array sizes! Value's size " + nPoints + " while error's size is " + errp.length);
        }
        if (nPoints != errm.length) {
            throw new IllegalArgumentException("Incompatible array sizes! Value's size " + nPoints + " while error's size is " + errm.length);
        }
        if (this.size() == 0) {
            this.addNPoints(nPoints);
        }
        if (nPoints != this.size()) {
            throw new IllegalArgumentException("Array size " + nPoints + " is incompatible with the number of points " + this.size());
        }
        for (int i = 0; i < nPoints; ++i) {
            IMeasurement meas = this.point(i).coordinate(coord);
            meas.setValue(values[i]);
            meas.setErrorMinus(errm[i]);
            meas.setErrorPlus(errp[i]);
        }
    }

    protected void setDimension(int dimOfPoints) {
        this.dimension = dimOfPoints;
    }

    private void addNPoints(int n) {
        for (int i = 0; i < n; ++i) {
            this.addPoint();
        }
    }
}

