/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IDataPoint;
import hep.aida.IMeasurement;
import hep.aida.ref.histogram.Measurement;

public class DataPoint
implements IDataPoint {
    private int dimension;
    private IMeasurement[] measurements;

    public DataPoint(int dim) {
        this.dimension = dim;
        this.measurements = new Measurement[dim];
        for (int i = 0; i < this.dimension; ++i) {
            this.measurements[i] = new Measurement();
        }
    }

    public DataPoint(IDataPoint p) {
        this.dimension = p.dimension();
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.measurements[i] = new Measurement(p.coordinate(i));
        }
    }

    public DataPoint(IMeasurement[] meas) {
        this.dimension = meas.length;
        this.measurements = meas;
    }

    public DataPoint(double[] val) {
        this.dimension = val.length;
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.measurements[i] = new Measurement(val[i]);
        }
    }

    public DataPoint(double[] val, double[] err) {
        if (val.length != err.length) {
            throw new IllegalArgumentException("DataPoint Constructor: Value and Error arrays are not the same size");
        }
        this.dimension = val.length;
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.measurements[i] = new Measurement(val[i], err[i]);
        }
    }

    public DataPoint(double[] val, double[] errMinus, double[] errPlus) {
        if (val.length != errPlus.length) {
            throw new IllegalArgumentException("DataPoint Constructor: Value and Error arrays are not the same size");
        }
        if (val.length != errMinus.length) {
            throw new IllegalArgumentException("DataPoint Constructor: Value and Error arrays are not the same size");
        }
        this.dimension = val.length;
        this.measurements = new Measurement[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.measurements[i] = new Measurement(val[i], errMinus[i], errPlus[i]);
        }
    }

    public int dimension() {
        return this.dimension;
    }

    public IMeasurement coordinate(int coord) {
        return this.measurements[coord];
    }

    public double lowerExtent(int coord) throws IllegalArgumentException {
        double le = this.measurements[coord].value();
        if (!Double.isNaN(this.measurements[coord].errorMinus())) {
            le -= this.measurements[coord].errorMinus();
        }
        return le;
    }

    public double upperExtent(int coord) throws IllegalArgumentException {
        double ue = this.measurements[coord].value();
        if (!Double.isNaN(this.measurements[coord].errorPlus())) {
            ue += this.measurements[coord].errorPlus();
        }
        return ue;
    }
}

