/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.ICloud2D;
import hep.aida.IHistogram2D;
import hep.aida.ref.histogram.Cloud;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.VariableAxis;
import java.util.ArrayList;

public class Cloud2D
extends Cloud
implements ICloud2D {
    private int nEntries = 0;
    private double lowerEdgeX;
    private double upperEdgeX;
    private double lowerEdgeY;
    private double upperEdgeY;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;
    private IHistogram2D histo;
    protected double sumOfWeights;
    private ArrayList xValuesArray = new ArrayList();
    private ArrayList yValuesArray = new ArrayList();
    private ArrayList weightsArray = new ArrayList();
    private double[] xValues;
    private double[] yValues;
    private double[] weights;

    public Cloud2D() {
        super("", "", 2, 0, "");
    }

    protected Cloud2D(String name, String title, int nMax, String options) {
        super(name, title, 2, nMax, options);
    }

    public void fill(double xValue, double yValue) {
        this.fill(xValue, yValue, 1.0);
    }

    public void fill(double xValue, double yValue, double weight) {
        if (this.nEntries == 0) {
            this.lowerEdgeX = this.upperEdgeX = xValue;
            this.lowerEdgeY = this.upperEdgeY = yValue;
        } else {
            if (xValue < this.lowerEdgeX) {
                this.lowerEdgeX = xValue;
            }
            if (xValue > this.upperEdgeX) {
                this.upperEdgeX = xValue;
            }
            if (yValue < this.lowerEdgeY) {
                this.lowerEdgeY = yValue;
            }
            if (yValue > this.upperEdgeY) {
                this.upperEdgeY = yValue;
            }
        }
        if (this.histo != null) {
            this.histo.fill(xValue, yValue, weight);
        } else if (this.autoConvert() && this.nEntries == this.maxEntries) {
            if (this.histo != null) {
                throw new RuntimeException("Cloud already been converted");
            }
            this.histo = this.toShowableHistogram(this.convBins, this.lowerEdgeX, this.upperEdgeX, this.convBins, this.lowerEdgeY, this.upperEdgeY, true);
            this.histo.fill(xValue, yValue, weight);
            this.weights = null;
            this.xValues = null;
            this.yValues = null;
            this.xValuesArray.clear();
            this.yValuesArray.clear();
            this.weightsArray.clear();
            this.xValuesArray = null;
            this.yValuesArray = null;
            this.weightsArray = null;
        } else {
            if (this.nEntries % this.arraySize == 0) {
                this.xValues = new double[this.arraySize];
                this.yValues = new double[this.arraySize];
                this.weights = new double[this.arraySize];
                this.xValuesArray.add(this.xValues);
                this.yValuesArray.add(this.yValues);
                this.weightsArray.add(this.weights);
            }
            this.xValues[this.nEntries % this.arraySize] = xValue;
            this.yValues[this.nEntries % this.arraySize] = yValue;
            this.weights[this.nEntries % this.arraySize] = weight;
            this.sumOfWeights += weight;
            this.meanX += xValue * weight;
            this.rmsX += xValue * xValue * weight;
            this.meanY += yValue * weight;
            this.rmsY += yValue * yValue * weight;
            ++this.nEntries;
            if (this.nEntries > this.maxEntries && this.maxEntries > 0) {
                throw new IllegalArgumentException();
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double lowerEdgeX() {
        return this.lowerEdgeX;
    }

    public double lowerEdgeY() {
        return this.lowerEdgeY;
    }

    public double upperEdgeX() {
        return this.upperEdgeX;
    }

    public double upperEdgeY() {
        return this.upperEdgeY;
    }

    public void setLowerEdgeX(double lowerEdgeX) {
        this.lowerEdgeX = lowerEdgeX;
    }

    public void setLowerEdgeY(double lowerEdgeY) {
        this.lowerEdgeY = lowerEdgeY;
    }

    public void setUpperEdgeX(double upperEdgeX) {
        this.upperEdgeX = upperEdgeX;
    }

    public void setUpperEdgeY(double upperEdgeY) {
        this.upperEdgeY = upperEdgeY;
    }

    public double valueX(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.xValuesArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double valueY(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.yValuesArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double weight(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.weightsArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double meanX() {
        if (this.histo != null) {
            return this.histo.meanX();
        }
        return this.meanX / this.sumOfWeights();
    }

    public double meanY() {
        if (this.histo != null) {
            return this.histo.meanY();
        }
        return this.meanY / this.sumOfWeights();
    }

    public double rmsX() {
        if (this.histo != null) {
            return this.histo.rmsX();
        }
        return Math.sqrt(this.rmsX / this.sumOfWeights() - this.meanX * this.meanX / this.sumOfWeights() / this.sumOfWeights());
    }

    public double rmsY() {
        if (this.histo != null) {
            return this.histo.rmsY();
        }
        return Math.sqrt(this.rmsY / this.sumOfWeights() - this.meanY * this.meanY / this.sumOfWeights() / this.sumOfWeights());
    }

    public int entries() {
        if (this.histo != null) {
            return this.histo.allEntries();
        }
        return this.nEntries;
    }

    public void convert(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        this.histo = this.toShowableHistogram(nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, false);
    }

    public IHistogram2D toShowableHistogram(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, boolean useMargin) {
        double uey;
        if (this.histo != null) {
            return this.histo;
        }
        double lex = lowerEdgeX != upperEdgeX ? lowerEdgeX : lowerEdgeX - 1.0;
        double uex = lowerEdgeX != upperEdgeX ? upperEdgeX : upperEdgeX + 1.0;
        double ley = lowerEdgeY != upperEdgeY ? lowerEdgeY : lowerEdgeY - 1.0;
        double d = uey = lowerEdgeY != upperEdgeY ? upperEdgeY : upperEdgeY + 1.0;
        if (useMargin) {
            lex -= this.margin() * Math.abs(lex);
            uex += this.margin() * Math.abs(uex);
            ley -= this.margin() * Math.abs(ley);
            uey += this.margin() * Math.abs(uey);
        }
        Histogram2D hist = new Histogram2D(this.name(), this.title(), new FixedAxis(nBinsX, lex, uex), new FixedAxis(nBinsY, ley, uey), "");
        for (int i = 0; i < this.nEntries; ++i) {
            hist.fill(this.valueX(i), this.valueY(i), this.weight(i));
        }
        return hist;
    }

    public void convert(double[] binEdgesX, double[] binEdgesY) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        Histogram2D hist = new Histogram2D(this.name(), this.title(), new VariableAxis(binEdgesX), new VariableAxis(binEdgesY), "");
        for (int i = 0; i < this.nEntries; ++i) {
            hist.fill(this.valueX(i), this.valueY(i), this.weight(i));
        }
        this.histo = hist;
    }

    public boolean isConverted() {
        return this.histo != null;
    }

    public IHistogram2D histogram() throws RuntimeException {
        if (this.histo == null) {
            throw new RuntimeException("Cloud has not been converted");
        }
        return this.histo;
    }

    public void setHistogram(IHistogram2D hist) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        this.histo = hist;
    }

    public void fillHistogram(IHistogram2D hist2d) {
        if (this.histo != null) {
            throw new IllegalArgumentException("Cloud has already been converted");
        }
        for (int i = 0; i < this.nEntries; ++i) {
            hist2d.fill(this.valueX(i), this.valueY(i), this.weight(i));
        }
    }

    public void reset() {
        this.nEntries = 0;
        this.lowerEdgeX = Double.NaN;
        this.upperEdgeX = Double.NaN;
        this.lowerEdgeY = Double.NaN;
        this.upperEdgeY = Double.NaN;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
        this.sumOfWeights = 0.0;
        if (this.histo != null) {
            this.histo.reset();
        }
        this.histo = null;
        this.xValuesArray = new ArrayList();
        this.yValuesArray = new ArrayList();
        this.weightsArray = new ArrayList();
        this.xValues = null;
        this.yValues = null;
        this.weights = null;
        super.reset();
    }

    public void convertToHistogram() {
        if (this.histo != null) {
            throw new IllegalArgumentException("Cloud has already been converted to an Histogram");
        }
        this.histo = this.toShowableHistogram(50, this.lowerEdgeX(), this.upperEdgeX(), 50, this.lowerEdgeY(), this.upperEdgeY(), true);
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        if (this.isConverted()) {
            this.histo.scale(scaleFactor);
        } else {
            for (int i = 0; i < this.entries(); ++i) {
                double[] weights = (double[])this.weightsArray.get(i / this.arraySize);
                int n = i % this.arraySize;
                weights[n] = weights[n] * scaleFactor;
            }
            this.sumOfWeights *= scaleFactor;
            this.meanX *= scaleFactor;
            this.rmsX *= scaleFactor;
            this.meanY *= scaleFactor;
            this.rmsY *= scaleFactor;
        }
    }

    public double sumOfWeights() {
        if (this.histo != null) {
            return this.histo.sumAllBinHeights();
        }
        return this.sumOfWeights;
    }
}

