/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.hbook;

import hep.aida.IManagedObject;
import hep.aida.dev.IDevTree;
import hep.aida.dev.IOnDemandStore;
import hep.aida.ref.hbook.Converter;
import hep.io.hbook.CompositeHbookObject;
import hep.io.hbook.HbookFile;
import hep.io.hbook.HbookObject;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;

public class HBookStore
implements IOnDemandStore {
    private HbookFile file;
    private boolean recursive;

    public boolean isReadOnly() {
        return true;
    }

    public void read(IDevTree tree, Map options, boolean readOnly, boolean createNew) throws IOException {
        String storeName = tree.storeName();
        this.file = new HbookFile(tree.storeName());
        Enumeration e = this.file.getTopLevelDirectory().getChildren();
        this.recursive = options.containsKey("recursive");
        this.addEntries(tree, e, "/");
    }

    public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (this.file == null) {
            throw new IOException("HbookFile is not open.");
        }
        HbookObject folder = this.file.getTopLevelDirectory();
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.countTokens() > 0) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ((folder = folder.getChild(token)) instanceof CompositeHbookObject) continue;
                throw new IllegalArgumentException("Path " + path + " does not point to a directory in the HBOOK file " + tree.storeName());
            }
        }
        Enumeration e = folder.getChildren();
        this.addEntries(tree, e, path);
    }

    private void addEntries(IDevTree tree, Enumeration e, String path) {
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            IManagedObject im = Converter.convert(o);
            if (im != null) {
                tree.add(path, im);
                continue;
            }
            if (!(o instanceof CompositeHbookObject)) continue;
            CompositeHbookObject c = (CompositeHbookObject)o;
            String newPath = path.endsWith("/") ? path + c.getName() : path + "/" + c.getName();
            tree.mkdirs(newPath);
            if (!this.recursive) continue;
            this.addEntries(tree, c.getChildren(), newPath);
        }
        tree.hasBeenFilled(path);
    }

    public void commit(IDevTree tree, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }
}

