/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IEvaluator;
import hep.aida.ITuple;
import hep.aida.ext.IRange;
import hep.aida.ext.IVariable;
import hep.aida.ref.function.Range;
import java.util.ArrayList;

public class Variable
implements IVariable {
    private double currentValue;
    private double varError = Double.NaN;
    private String name;
    private String label;
    private ArrayList ranges = new ArrayList();
    private boolean dependent = true;
    private boolean fixed = false;
    private boolean useBounds = false;
    private double stepSize;
    private String units = "";
    private double stepFrac = 0.01;

    public Variable(String name, String label, double value) {
        this.name = name;
        this.label = label;
        this.currentValue = value;
        this.stepSize = this.stepFrac * Math.abs(value);
    }

    public Variable(String name, String label, double value, double lowerBound, double upperBound) {
        this.name = name;
        this.label = label;
        this.currentValue = value;
        this.stepSize = this.stepFrac * Math.abs(value);
        this.addRange(new Range(lowerBound, upperBound));
    }

    public Variable(String name, String label, double lowerBound, double upperBound) {
        this.name = name;
        this.label = label;
        this.currentValue = (upperBound + lowerBound) / 2.0;
        this.stepSize = this.stepFrac * Math.abs(this.currentValue);
        this.addRange(new Range(lowerBound, upperBound));
    }

    public String label() {
        return this.label;
    }

    public String name() {
        return this.name;
    }

    public boolean setValue(double value) {
        if (!this.useBounds()) {
            this.currentValue = value;
            return true;
        }
        if (this.isInRange(value)) {
            this.currentValue = value;
            return true;
        }
        return false;
    }

    public double value() {
        return this.currentValue;
    }

    public double error() {
        return this.varError;
    }

    public void setError(double error) {
        this.varError = error;
    }

    public void setRange(double lower, double upper) {
        this.ranges.clear();
        this.addRange(new Range(lower, upper));
    }

    public void addRange(double lower, double upper) {
        this.addRange(new Range(lower, upper));
    }

    public void addRange(IRange range) {
        this.ranges.add(range);
    }

    public boolean isInRange() {
        return this.isInRange(this.currentValue);
    }

    public boolean isInRange(double value) {
        int nRanges = this.nRanges();
        if (nRanges == 0) {
            return true;
        }
        for (int i = 0; i < nRanges; ++i) {
            if (!((IRange)this.ranges.get(i)).isInRange(value)) continue;
            return true;
        }
        return false;
    }

    public int nRanges() {
        return this.ranges.size();
    }

    public void setDependent(boolean state) {
        this.dependent = state;
    }

    public boolean isDependent() {
        return this.dependent;
    }

    public void setStep(double step) {
        this.stepSize = step;
    }

    public double step() {
        return this.stepSize;
    }

    public void setFixed(boolean state) {
        this.fixed = state;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setUseBounds(boolean state) {
        this.useBounds = state;
    }

    public boolean useBounds() {
        return this.useBounds;
    }

    public void connect(ITuple data) {
    }

    public void connect(IEvaluator ev) {
    }

    public boolean isConnected() {
        return false;
    }

    public ITuple connection() {
        return null;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String units() {
        return this.units;
    }

    public IRange getRange(int index) {
        return (IRange)this.ranges.get(index);
    }
}

