/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IRangeSet;
import hep.aida.ref.function.Range;
import java.util.ArrayList;
import java.util.Random;

public class RangeSet
implements IRangeSet {
    private ArrayList set;
    private boolean rangeChanged = true;
    private Random r = new Random();

    public RangeSet() {
        this.set = new ArrayList();
        Range r = new Range();
        this.set.add(r);
    }

    public RangeSet(double xMin, double xMax) {
        this.set = new ArrayList();
        Range r = new Range(xMin, xMax);
        this.set.add(r);
    }

    public RangeSet(double[] xMin, double[] xMax) {
        if (xMin.length != xMax.length) {
            throw new IllegalArgumentException("xMin and xMax arrays must have the same size.");
        }
        this.set = new ArrayList();
        Range r = new Range(xMin[0], xMax[0]);
        this.set.add(r);
        if (xMin.length > 1) {
            for (int i = 1; i < xMin.length; ++i) {
                this.include(xMin[i], xMax[i]);
            }
        }
    }

    public double PLUS_INF() {
        return Double.POSITIVE_INFINITY;
    }

    public double MINUS_INF() {
        return Double.NEGATIVE_INFINITY;
    }

    public int size() {
        return this.set.size();
    }

    public double length() {
        if (this.size() == 0) {
            throw new RuntimeException("No length for this Range set");
        }
        double length = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            length += ((Range)this.set.get(i)).upperBound() - ((Range)this.set.get(i)).lowerBound();
        }
        return length;
    }

    public double generatePoint() {
        double rnd = Math.random();
        double l = this.length();
        double pl = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double rlb;
            double rub = ((Range)this.set.get(i)).upperBound();
            if (!(rnd < (pl += rub - (rlb = ((Range)this.set.get(i)).lowerBound())) / l)) continue;
            return rlb + (pl / l - rnd) * l;
        }
        throw new RuntimeException("Problem with generating a point in the RangeSet");
    }

    public double[] lowerBounds() {
        if (this.size() == 0) {
            return null;
        }
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = ((Range)this.set.get(i)).lowerBound();
        }
        return tmp;
    }

    public double[] upperBounds() {
        if (this.size() == 0) {
            return null;
        }
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = ((Range)this.set.get(i)).upperBound();
        }
        return tmp;
    }

    public void include(double xMin, double xMax) {
        this.rangeChanged = true;
        if (xMin > xMax) {
            throw new IllegalArgumentException("xMax must be bigger tnan xMin.");
        }
        int r1 = -1;
        int r2 = -1;
        boolean range1 = true;
        boolean range2 = true;
        double min = Double.NaN;
        double max = Double.NaN;
        if (this.set.size() == 0) {
            this.set.add(new Range(xMin, xMax));
            return;
        }
        if (((Range)this.set.get(this.set.size() - 1)).upperBound() <= xMax && ((Range)this.set.get(0)).lowerBound() >= xMin) {
            this.excludeAll();
            this.include(xMin, xMax);
            return;
        }
        if (((Range)this.set.get(this.set.size() - 1)).upperBound() < xMin) {
            this.set.add(new Range(xMin, xMax));
            return;
        }
        if (((Range)this.set.get(0)).lowerBound() > xMax) {
            this.insert(0, new Range(xMin, xMax));
            return;
        }
        range1 = true;
        r1 = this.inRange(xMin);
        if (r1 < 0) {
            range1 = false;
            r1 = this.inGap(xMin);
            min = xMin;
        } else {
            min = ((Range)this.set.get(r1)).lowerBound();
        }
        range2 = true;
        r2 = this.inRange(xMax);
        if (r2 < 0) {
            range2 = false;
            r2 = this.inGap(xMax);
            max = xMax;
        } else {
            max = ((Range)this.set.get(r2)).upperBound();
        }
        if (range1 && range2 && r1 == r2) {
            return;
        }
        if (!range1 && !range2 && r1 == r2) {
            this.insert(r1, new Range(min, max));
            return;
        }
        if (range2) {
            this.remove(r1, r2);
            this.insert(r1, new Range(min, max));
            return;
        }
        if (!range2) {
            this.remove(r1, r2 - 1);
            this.insert(r1, new Range(min, max));
            return;
        }
    }

    public void exclude(double xMin, double xMax) {
        this.rangeChanged = true;
        if (xMin > xMax) {
            throw new IllegalArgumentException("xMax must be bigger than xMin.");
        }
        int r1 = -1;
        int r2 = -1;
        boolean range1 = true;
        boolean range2 = true;
        double min = Double.NaN;
        double max = Double.NaN;
        if (this.set.size() == 0) {
            return;
        }
        if (((Range)this.set.get(this.set.size() - 1)).upperBound() <= xMax && ((Range)this.set.get(0)).lowerBound() >= xMin) {
            this.excludeAll();
            return;
        }
        if (((Range)this.set.get(this.set.size() - 1)).upperBound() < xMin) {
            return;
        }
        if (((Range)this.set.get(0)).lowerBound() > xMax) {
            return;
        }
        range1 = true;
        r1 = this.inRange(xMin);
        if (r1 < 0) {
            range1 = false;
            r1 = this.inGap(xMin);
            min = xMin;
        } else {
            min = ((Range)this.set.get(r1)).lowerBound();
        }
        range2 = true;
        r2 = this.inRange(xMax);
        if (r2 < 0) {
            range2 = false;
            r2 = this.inGap(xMax);
            max = xMax;
        } else {
            max = ((Range)this.set.get(r2)).upperBound();
        }
        if (!range1 && !range2) {
            if (r1 == r2) {
                return;
            }
            this.remove(r1, r2 - 1);
            return;
        }
        if (range1) {
            this.insert(r1, new Range(min, xMin));
            ++r1;
            ++r2;
        }
        if (range2) {
            this.insert(r2 + 1, new Range(xMax, max));
        } else {
            --r2;
        }
        this.remove(r1, r2);
    }

    public void includeAll() {
        this.rangeChanged = true;
        this.set = new ArrayList();
        Range r = new Range();
        this.set.add(r);
    }

    public void excludeAll() {
        this.rangeChanged = true;
        this.set = new ArrayList();
    }

    public boolean isInRange(double point) {
        if (this.set.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.set.size(); ++i) {
            if (!((Range)this.set.get(i)).isInRange(point)) continue;
            return true;
        }
        return false;
    }

    private int inRange(double point) {
        if (this.set.size() == 0) {
            return -1;
        }
        for (int i = 0; i < this.set.size(); ++i) {
            if (!((Range)this.set.get(i)).isInRange(point)) continue;
            return i;
        }
        return -1;
    }

    private int inGap(double point) {
        if (this.set.size() == 0) {
            return -1;
        }
        if (((Range)this.set.get(0)).lowerBound() > point) {
            return 0;
        }
        if (((Range)this.set.get(this.set.size() - 1)).upperBound() < point) {
            return this.set.size();
        }
        for (int i = 0; i < this.set.size() - 1; ++i) {
            if (!(((Range)this.set.get(i)).upperBound() < point) || !(((Range)this.set.get(i + 1)).lowerBound() > point)) continue;
            return i + 1;
        }
        return -1;
    }

    private void insert(int index, Range r) {
        if (index > this.set.size() || index < 0) {
            throw new IllegalArgumentException("Wrong index: " + index + ", Set size=" + this.set.size());
        }
        if (index == this.set.size()) {
            this.set.add(r);
            return;
        }
        ArrayList<Range> tmp = new ArrayList<Range>();
        for (int i = 0; i < this.set.size() + 1; ++i) {
            if (i < index) {
                tmp.add((Range)this.set.get(i));
                continue;
            }
            if (i == index) {
                tmp.add(r);
                continue;
            }
            if (i <= index) continue;
            tmp.add((Range)this.set.get(i - 1));
        }
        this.set = tmp;
    }

    private void remove(int index1, int index2) {
        if (index1 > index2 || index1 >= this.set.size() || index2 >= this.set.size() || index1 < 0 || index2 < 0) {
            throw new IllegalArgumentException("Wrong index: index1=" + index1 + ", index2=" + index2 + ", Set size=" + this.set.size());
        }
        ArrayList<Range> tmp = new ArrayList<Range>();
        for (int i = 0; i < this.set.size(); ++i) {
            if (i >= index1 && i <= index2) continue;
            tmp.add((Range)this.set.get(i));
        }
        this.set = tmp;
    }

    public static void main(String[] args) {
        RangeSet set = new RangeSet();
        set.print();
        set.excludeAll();
        set.print();
        set.include(5.5, 7.6);
        set.print();
        set.include(14.5, 17.6);
        set.print();
        set.include(9.5, 12.6);
        set.print();
        set.include(6.5, 10.6);
        set.print();
        set.include(1.5, 3.6);
        set.print();
        set.include(5.1, 18.6);
        set.print();
        System.out.println("\n ****************** Start Excluding ******************\n");
        set.exclude(14.2, 16.7);
        set.print();
        set.exclude(7.2, 10.3);
        set.print();
        set.exclude(4.9, 11.4);
        set.print();
        set.exclude(2.1, 12.1);
        set.print();
        set.exclude(17.0, 18.0);
        set.print();
    }

    private void print() {
        int i;
        System.out.println("\n\n Size: " + this.set.size());
        for (i = 0; i < this.set.size(); ++i) {
            System.out.println(i + "\t lowerBound = " + ((Range)this.set.get(i)).lowerBound() + ",\t upperBound = " + ((Range)this.set.get(i)).upperBound());
        }
        System.out.println("");
        for (i = 0; i < 20; ++i) {
            System.out.println(i + "\t " + this.isInRange((double)i * 1.0));
        }
    }
}

