/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;

public class GaussianCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public GaussianCoreNotNorm(String str) {
        super(1, 3, new double[]{1.0, 0.0, 1.0});
        this.setTitle("GaussianCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "mean", "sigma"};
        this.setParameterNames(names);
    }

    public GaussianCoreNotNorm(String str, double[] pVal) {
        super(1, 3, pVal);
        this.setTitle("GaussianCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "mean", "sigma"};
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        return this.p[0] * Math.exp(-Math.pow(var[0] - this.p[1], 2.0) / (2.0 * Math.pow(this.p[2], 2.0)));
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        return new double[]{this.functionValue(var) * -2.0 * (var[0] - this.p[1]) / (2.0 * Math.pow(this.p[2], 2.0))};
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        double y = this.functionValue(var);
        return new double[]{y / this.p[0], y * 2.0 * (var[0] - this.p[1]) / (2.0 * Math.pow(this.p[2], 2.0)), y * 2.0 * (var[0] - this.p[1]) / (2.0 * Math.pow(this.p[2], 3.0))};
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }
}

