/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFitData;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.fitter.fitData.FitData;
import hep.aida.ref.function.FunctionCore;
import java.io.IOException;
import java.util.Random;

public class GaussianCoreNorm
extends FunctionCore {
    protected boolean providesNormalization;
    protected final double r2 = Math.sqrt(2.0);
    private final double[] erfc_coef = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18};
    private final double[] erfc2_coef = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18};
    private final double[] erfcc_coef = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};
    private final double erf_xbig = Math.sqrt(-Math.log(1.9678190753608168E-16));
    private final double erf_sqeps = Math.sqrt(2.2204460492503E-16);
    private final double erfc_xsml = -Math.sqrt(-Math.log(1.9678190753608168E-16));
    private double erfc_xmax;

    public GaussianCoreNorm(String str) {
        super(1, 2, new double[]{0.0, 1.0});
        this.setTitle("GaussianCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"mean", "sigma"};
        this.setParameterNames(names);
    }

    public GaussianCoreNorm(String str, double[] pVal) {
        super(1, 2, pVal);
        this.setTitle("GaussianCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"mean", "sigma"};
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        return Math.exp(-Math.pow(var[0] - this.p[0], 2.0) / (2.0 * Math.pow(this.p[1], 2.0)));
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        return new double[]{this.functionValue(var) * -2.0 * (var[0] - this.p[0]) / (2.0 * Math.pow(this.p[1], 2.0))};
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        double y = this.functionValue(var);
        return new double[]{y * 2.0 * (var[0] - this.p[0]) / (2.0 * Math.pow(this.p[1], 2.0)), y * 2.0 * (var[0] - this.p[0]) / (2.0 * Math.pow(Math.abs(this.p[1]), 3.0))};
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        return Math.sqrt(1.5707963267948966) * this.p[1] * (this.erf((xMax[0] - this.p[0]) / (this.r2 * this.p[1])) - this.erf((xMin[0] - this.p[0]) / (this.r2 * this.p[1])));
    }

    private double erf(double d) {
        double d1 = Double.NaN;
        double d2 = Math.abs(d);
        d1 = d2 <= 1.0 ? (d2 <= this.erf_sqeps ? 2.0 * d / 1.772453850905516 : d * (1.0 + this.csevl(2.0 * d * d - 1.0, this.erfc_coef))) : (d2 <= this.erf_xbig ? GaussianCoreNorm.sign(1.0 - this.erfc(d2), d) : GaussianCoreNorm.sign(1.0, d));
        return d1;
    }

    private double erfc(double d) {
        double d1 = Double.NaN;
        if (d <= this.erfc_xsml) {
            d1 = 2.0;
        } else if (d <= this.erfc_xmax) {
            double d2 = Math.abs(d);
            if (d2 <= 1.0) {
                d1 = d2 < this.erf_sqeps ? 1.0 - 2.0 * d / 1.772453850905516 : 1.0 - d * (1.0 + this.csevl(2.0 * d * d - 1.0, this.erfc_coef));
            } else {
                d1 = (d2 *= d2) <= 4.0 ? Math.exp(-d2) / Math.abs(d) * (0.5 + this.csevl((8.0 / d2 - 5.0) / 3.0, this.erfc2_coef)) : Math.exp(-d2) / Math.abs(d) * (0.5 + this.csevl(8.0 / d2 - 1.0, this.erfcc_coef));
                if (d < 0.0) {
                    d1 = 2.0 - d1;
                }
            }
        } else {
            d1 = 0.0;
        }
        return d1;
    }

    private double csevl(double d, double[] ad) {
        int i = ad.length;
        double d2 = 0.0;
        double d1 = 0.0;
        double d3 = 0.0;
        double d4 = 2.0 * d;
        for (int j = i - 1; j >= 0; --j) {
            d3 = d2;
            d2 = d1;
            d1 = d4 * d2 - d3 + ad[j];
        }
        return 0.5 * (d1 - d3);
    }

    public static double sign(double d, double d1) {
        double d2 = d >= 0.0 ? d : -d;
        return d1 >= 0.0 ? d2 : -d2;
    }

    public static void main(String[] args) throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IPlotterFactory pf = af.createPlotterFactory();
        IPlotter plotter = pf.create("JAS Plotter");
        plotter.createRegions(1, 2);
        IModelFunction f1 = (IModelFunction)ff.createFunctionByName("f1", "g");
        IModelFunction f2 = (IModelFunction)ff.createFunctionByName("f2", "G");
        IModelFunction f3 = (IModelFunction)ff.createFunctionByName("f3", "g");
        IModelFunction f4 = (IModelFunction)ff.createFunctionByName("f4", "G");
        IHistogram1D hist1 = hf.createHistogram1D("hist1", "hist1", 100, -5.0, 5.0);
        IHistogram1D hist2 = hf.createHistogram1D("hist2", "hist2", 100, -5.0, 5.0);
        IHistogram2D hist2d = hf.createHistogram2D("hist2d", "hist2d", 100, -5.0, 5.0, 10, -10.0, 0.0);
        Random r = new Random();
        ITuple tup = tf.create("tup", "tup", "double x0, double y");
        for (int i = 0; i < 50000; ++i) {
            double d;
            double x = 10.0 * (r.nextDouble() - 0.5);
            double y = r.nextDouble();
            if (!(y < (d = Math.exp(-(x + 0.7) * (x + 0.7) / 8.0)))) continue;
            hist1.fill(x);
            hist2d.fill(x, y);
            tup.fill(0, x);
            tup.fill(1, y);
            tup.addRow();
        }
        double[] chi2 = new double[]{500.0, 0.5, 0.5};
        f1.setParameters(chi2);
        f2.setParameters(chi2);
        Fitter fitter = new Fitter("Chi2", "minuit", null);
        IFitResult fr = fitter.fit((IBaseHistogram)hist1, (IFunction)f2);
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f1);
        plotter.currentRegion().plot(fr.fittedFunction());
        f3.normalize(true);
        f4.normalize(true);
        double[] ml = new double[]{-1.0, 3.0};
        f3.setParameters(ml);
        f4.setParameters(ml);
        System.out.println("Variable names: " + f4.variableName(0));
        Object ev = null;
        FitData fd = new FitData();
        Fitter fitter2 = new Fitter("uml", "minuit", null);
        String[] colNames = new String[]{"x0"};
        fd.createConnection(tup, colNames);
        fd.range(0).excludeAll();
        fd.range(0).include(-5.0, 5.0);
        IFitResult ml_fr = fitter2.fit((IFitData)fd, (IFunction)f3);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f3);
        plotter.currentRegion().plot(ml_fr.fittedFunction());
        plotter.show();
    }
}

