/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;

public class GaussianCore2DNotNorm
extends FunctionCore {
    protected boolean providesNormalization;
    protected final double r2 = Math.sqrt(2.0);

    public GaussianCore2DNotNorm(String str) {
        super(2, 5, new double[]{1.0, 0.0, 1.0, 0.0, 1.0});
        this.setTitle("GaussianCore2DNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "meanX", "sigmaX", "meanY", "sigmaY"};
        this.setParameterNames(names);
    }

    public GaussianCore2DNotNorm(String str, double[] pVal) {
        super(2, 5, pVal);
        this.setTitle("GaussianCore2DNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "meanX", "sigmaX", "meanY", "sigmaY"};
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        return this.p[0] * Math.exp(-Math.pow(var[0] - this.p[1], 2.0) / (2.0 * Math.pow(this.p[2], 2.0))) * Math.exp(-Math.pow(var[1] - this.p[3], 2.0) / (2.0 * Math.pow(this.p[4], 2.0)));
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        return new double[]{this.functionValue(var) * -2.0 * (var[0] - this.p[1]) / (2.0 * Math.pow(this.p[2], 2.0)), this.functionValue(var) * -2.0 * (var[1] - this.p[3]) / (2.0 * Math.pow(this.p[4], 2.0))};
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        double f = this.functionValue(var);
        return new double[]{f / this.p[0], f * 2.0 * (var[0] - this.p[1]) / (2.0 * Math.pow(this.p[2], 2.0)), f * 2.0 * (var[0] - this.p[1]) / (2.0 * Math.pow(Math.abs(this.p[2]), 3.0)), f * 2.0 * (var[1] - this.p[3]) / (2.0 * Math.pow(this.p[4], 2.0)), f * 2.0 * (var[1] - this.p[3]) / (2.0 * Math.pow(Math.abs(this.p[4]), 3.0))};
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }
}

