/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IFunction;
import hep.aida.IFunctionCatalog;
import hep.aida.IFunctionFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.tree.Tree;

public class FunctionFactory
implements IFunctionFactory {
    private Tree tree;
    private FunctionCatalog catalog;
    private static final char separatorChar = '/';

    private String nameInPath(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    private String parentPath(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return path.substring(0, index);
    }

    public FunctionFactory(ITree tree) {
        this((Tree)tree);
    }

    protected FunctionFactory(Tree tree) {
        this.tree = tree;
        this.catalog = FunctionCatalog.getFunctionCatalog();
    }

    public IFunction createFunctionByName(String path, String model) {
        IFunction result = this.catalog.create(this.nameInPath(path), model);
        if (this.tree != null && path != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IFunction createFunctionFromScript(String path, int dim, String valexpr, String parameters, String description) {
        String gradexpr = null;
        return this.createFunctionFromScript(path, dim, valexpr, parameters, description, gradexpr);
    }

    public IFunction createFunctionFromScript(String path, int dim, String valexpr, String parameters, String description, String gradexpr) {
        if (valexpr == null || valexpr.equals("")) {
            throw new IllegalArgumentException("Can not create function from an empty string");
        }
        String codeletString = new String("codelet:" + description + ":verbatim:jel : " + dim + " : " + valexpr + " : " + parameters + " : " + gradexpr);
        IFunction result = this.catalog.getFunctionCreator().createFromCodelet(this.nameInPath(path), codeletString);
        if (this.tree != null && path != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IFunction cloneFunction(String path, IFunction f) {
        IFunction clone = this.catalog.getFunctionCreator().clone(this.nameInPath(path), f);
        if (this.tree != null && path != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)clone);
        }
        return clone;
    }

    public IFunctionCatalog catalog() {
        return this.catalog;
    }
}

