/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionCatalog;
import hep.aida.IFunctionFactory;
import hep.aida.IModelFunction;
import hep.aida.ITree;
import hep.aida.dev.IDevFunctionCatalog;
import hep.aida.ref.function.FunctionCreator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TreeMap;

public class FunctionCatalog
implements IDevFunctionCatalog,
Serializable {
    public static String[] defaultNames = new String[]{"g2", "g", "e", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9"};
    public static String prefix = "codelet:";
    protected static FunctionCatalog catalog = null;
    protected TreeMap hash;
    protected TreeMap userHash;
    protected FunctionCreator creator = new FunctionCreator();

    public static FunctionCatalog getFunctionCatalog() {
        if (catalog == null) {
            catalog = new FunctionCatalog();
        }
        return catalog;
    }

    public static FunctionCatalog getFunctionCatalog(String fileName) throws IOException {
        if (catalog == null) {
            catalog = new FunctionCatalog(fileName);
        }
        return catalog;
    }

    protected FunctionCatalog() {
        this.hash = new TreeMap();
        this.userHash = new TreeMap();
        for (int i = 0; i < defaultNames.length; ++i) {
            this.hash.put(defaultNames[i], new String("codelet:" + defaultNames[i] + ":catalog"));
        }
    }

    protected FunctionCatalog(String fileName) throws IOException {
        this.hash = new TreeMap();
        this.userHash = new TreeMap();
        for (int i = 0; i < defaultNames.length; ++i) {
            this.hash.put(defaultNames[i], new String("codelet:" + defaultNames[i] + ":catalog"));
        }
        this.loadAll(fileName);
    }

    public boolean add(String nameId, IFunction f) {
        return this.add(nameId, f.codeletString());
    }

    public boolean add(String nameId, String codelet) {
        if (this.hash.containsKey(nameId.toLowerCase())) {
            return false;
        }
        if (this.userHash.containsKey(nameId)) {
            return false;
        }
        this.userHash.put(nameId, codelet);
        return true;
    }

    public String[] list() {
        int i;
        String[] array = new String[this.hash.size() + this.userHash.size()];
        Object[] entries = this.hash.keySet().toArray();
        Object[] userEntries = this.userHash.keySet().toArray();
        for (i = 0; i < this.hash.size(); ++i) {
            array[i] = (String)entries[i];
        }
        for (i = 0; i < this.userHash.size(); ++i) {
            array[i + this.hash.size()] = (String)userEntries[i];
        }
        return array;
    }

    public String codeletForName(String catalogName) {
        String tmp = catalogName.trim();
        String str = (String)this.hash.get(tmp.toLowerCase());
        if (str == null) {
            str = (String)this.userHash.get(tmp);
        }
        if (str == null) {
            throw new IllegalArgumentException("Catalog does not contain name \"" + catalogName + "\"");
        }
        return str;
    }

    public IFunction create(String model) {
        String codeletString = this.codeletForName(model);
        return this.creator.createFromCodelet(codeletString);
    }

    public IFunction create(String name, String model) {
        String codeletString = this.codeletForName(model);
        return this.creator.createFromCodelet(name, codeletString);
    }

    public String[] defaultFunctions() {
        return defaultNames;
    }

    public void loadAll(String nameOnDisk) throws IOException {
        try {
            FileInputStream in = new FileInputStream(nameOnDisk);
            ObjectInputStream s = new ObjectInputStream(in);
            this.userHash = (TreeMap)s.readObject();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not load FunctionCatalog. Please check file:" + nameOnDisk, e);
        }
    }

    public void storeAll(String nameOnDisk) throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(nameOnDisk);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(this.userHash);
            s.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not save FunctionCatalog. Please check file:" + nameOnDisk, e);
        }
    }

    public void remove(String nameId) {
        if (!this.hash.containsKey(nameId)) {
            throw new IllegalArgumentException("Catalog does not contain function \"" + nameId + "\"");
        }
        this.hash.remove(nameId);
    }

    public FunctionCreator getFunctionCreator() {
        return this.creator;
    }

    public String toString() {
        int i;
        Object[] keys;
        String str = "";
        str = str + "\nFunctionCatalog:            prefix = " + prefix + "\n";
        str = str + "------------------\n";
        if (!this.hash.isEmpty()) {
            str = str + "\n\tDefault Functions:\n";
            keys = this.hash.keySet().toArray();
            for (i = 0; i < keys.length; ++i) {
                str = str + "\t\t" + (String)keys[i] + "\t" + (String)this.hash.get(keys[i]) + "\n";
            }
        }
        if (!this.userHash.isEmpty()) {
            str = str + "\n\tAdditional Functions:\n";
            keys = this.userHash.keySet().toArray();
            for (i = 0; i < keys.length; ++i) {
                str = str + "\t\t" + (String)keys[i] + "\t" + (String)this.userHash.get(keys[i]) + "\n";
            }
        }
        return str;
    }

    public static void main(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException {
        FunctionCatalog.test1();
        FunctionCatalog.test2();
    }

    public static void test1() throws ClassNotFoundException, FileNotFoundException, IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IModelFunction f1 = (IModelFunction)ff.createFunctionFromScript("name1", 1, "a*(1+c*sin(x[0]-d))", "a,c,d", "f1");
        IModelFunction f2 = (IModelFunction)ff.createFunctionByName("name-2", "P5");
        IFunctionCatalog cat = ff.catalog();
        System.out.println(cat + "\n");
        cat.add("script1", (IFunction)f1);
        cat.add("poly-5", (IFunction)f2);
        String[] names = cat.list();
        for (int i = 0; i < names.length; ++i) {
            System.out.println(i + "\t " + names[i]);
        }
        System.out.println(cat + "\n");
        String codelet = "codelet:hep.aida.ref.TestUserFunction:file://afs/slac.stanford.edu/u/ey/serbo/java-tests/freehep-hep.jar";
        cat.add("Victor-test", codelet);
        System.out.println(cat + "\n");
        cat.storeAll("Cat");
    }

    public static void test2() throws ClassNotFoundException, FileNotFoundException, IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IFunctionCatalog cat = ff.catalog();
        cat.loadAll("Cat");
        System.out.println(cat + "\n");
        IFunction f = ff.createFunctionByName("TreeName", "Victor-test");
        System.out.println(FunctionCreator.toString(f));
    }
}

