/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;

public class ExponentialCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public ExponentialCoreNotNorm(String str) {
        super(1, 2, new double[]{1.0, 1.0});
        this.setTitle("ExponentialCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "exponent"};
        this.setParameterNames(names);
    }

    public ExponentialCoreNotNorm(String str, double[] pVal) {
        super(1, 2, pVal);
        this.setTitle("ExponentialCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "exponent"};
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        return this.p[0] * Math.exp(var[0] * this.p[1]);
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        double[] tmp = new double[]{0.0};
        return new double[]{this.functionValue(var) * this.p[1]};
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        double y = this.functionValue(var);
        return new double[]{y / this.p[0], y * var[0]};
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }
}

