/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitMethod;

import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ref.fitter.fitMethod.IFitMethod;

public class LeastSquaresFitMethod
implements IFitMethod {
    public double evaluateSumElement(IDevFitDataIterator dataIter, IFunction function) {
        return Math.pow(dataIter.value() - function.value(dataIter.vars()), 2.0);
    }

    public int fitType() {
        return 0;
    }

    public boolean providesGradientSumElement() {
        return true;
    }

    public double[] evaluateGradientSumElement(IDevFitDataIterator dataIter, IFunction function) {
        double f = function.value(dataIter.vars());
        double[] der = ((IModelFunction)function).parameterGradient(dataIter.vars());
        double[] newDer = new double[der.length];
        double val = dataIter.value();
        double d = val - f;
        double c = -2.0 * d;
        for (int i = 0; i < der.length; ++i) {
            newDer[i] = der[i] * c;
        }
        return newDer;
    }
}

