/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitMethod;

import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ref.fitter.fitMethod.IFitMethod;

public class ChiSquaredFitMethod
implements IFitMethod {
    public double evaluateSumElement(IDevFitDataIterator dataIter, IFunction function) {
        return Math.pow(dataIter.value() - function.value(dataIter.vars()), 2.0) / Math.pow(dataIter.error(), 2.0);
    }

    public int fitType() {
        return 0;
    }

    public boolean providesGradientSumElement() {
        return true;
    }

    public double[] evaluateGradientSumElement(IDevFitDataIterator dataIter, IFunction function) {
        double f = function.value(dataIter.vars());
        double[] der = ((IModelFunction)function).parameterGradient(dataIter.vars());
        double[] newDer = new double[der.length];
        double val = dataIter.value();
        double err = dataIter.error();
        double c = 2.0 * (f - val) / (err * err);
        for (int i = 0; i < der.length; ++i) {
            newDer[i] = der[i] * c;
        }
        return newDer;
    }
}

