/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter.fitMethod;

import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ref.fitter.fitMethod.IFitMethod;

public class BinnedMaximumLikelihoodFitMethod
implements IFitMethod {
    public double evaluateSumElement(IDevFitDataIterator dataIter, IFunction function) {
        double fVal = function.value(dataIter.vars());
        return fVal - dataIter.value() * Math.log(fVal);
    }

    public int fitType() {
        return 0;
    }

    public boolean providesGradientSumElement() {
        return true;
    }

    public double[] evaluateGradientSumElement(IDevFitDataIterator dataIter, IFunction function) {
        double f = function.value(dataIter.vars());
        double[] der = ((IModelFunction)function).parameterGradient(dataIter.vars());
        double[] newDer = new double[der.length];
        double val = dataIter.value();
        double c = 1.0 - val / f;
        for (int i = 0; i < der.length; ++i) {
            newDer[i] = der[i] * c;
        }
        return newDer;
    }
}

