/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IFitData;
import hep.aida.IFitParameterSettings;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IModelFunction;
import hep.aida.IProfile;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ITupleFactory;
import hep.aida.dev.IDevFitData;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ext.IOptimizer;
import hep.aida.ext.IOptimizerFactory;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.fitter.FitParameterSettings;
import hep.aida.ref.fitter.FitResult;
import hep.aida.ref.fitter.fitData.FitData;
import hep.aida.ref.fitter.fitMethod.IFitMethod;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.optimizer.minuit.MinuitOptimizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class Fitter
implements IFitter {
    private String engineType;
    private IOptimizer optimizer = null;
    private String fitMethodType;
    private IFitMethod fitMethod = null;
    private IFunction fitFunction;
    private Hashtable fitParHash = new Hashtable();
    private boolean useGradient = true;
    private ArrayList constraintList = new ArrayList();
    private Hashtable simpleConstraintHash = new Hashtable();

    public Fitter(String fitMethodType, String engineType, String options) throws IllegalArgumentException {
        this.setFitMethod(fitMethodType);
        this.setEngine(engineType);
    }

    public void setEngine(String engineType) throws IllegalArgumentException {
        if (engineType == null || engineType.length() == 0) {
            engineType = "uncmin";
        }
        String enType = engineType.toLowerCase();
        Lookup.Template template = new Lookup.Template(IOptimizerFactory.class, enType, null);
        Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
        if (item == null) {
            throw new IllegalArgumentException("Unknown engine type: " + engineType);
        }
        this.engineType = engineType;
        this.optimizer = ((IOptimizerFactory)item.getInstance()).create();
    }

    public String engineName() {
        return this.engineType;
    }

    public void setFitMethod(String fitMethodType) throws IllegalArgumentException {
        if (fitMethodType == null || fitMethodType.length() == 0) {
            fitMethodType = "chi2";
        }
        String fitMet = fitMethodType.toLowerCase();
        Lookup.Template template = new Lookup.Template(IFitMethod.class, fitMet, null);
        Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
        if (item == null) {
            throw new IllegalArgumentException("Unknown IFitMethod type: " + fitMethodType);
        }
        this.fitMethodType = fitMethodType;
        this.fitMethod = (IFitMethod)item.getInstance();
    }

    public String fitMethodName() {
        return this.fitMethodType;
    }

    public IFitParameterSettings fitParameterSettings(String name) {
        if (this.fitParHash.containsKey(name)) {
            return (IFitParameterSettings)this.fitParHash.get(name);
        }
        FitParameterSettings fitPar = new FitParameterSettings(name);
        this.fitParHash.put(name, fitPar);
        return fitPar;
    }

    public String[] listParameterSettings() {
        int size = this.fitParHash.size();
        String[] parNames = new String[size];
        Enumeration e = this.fitParHash.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            parNames[i] = (String)e.nextElement();
            ++i;
        }
        return parNames;
    }

    public void resetParameterSettings() {
        this.fitParHash.clear();
    }

    public IFitResult fit(IFitData d, IFunction originalFunction) {
        String name = "";
        if (originalFunction instanceof IManagedObject) {
            name = ((IManagedObject)originalFunction).name();
        }
        name = name + " " + this.engineName() + " fit";
        IFunction fClone = FunctionCatalog.getFunctionCatalog().getFunctionCreator().clone(name, originalFunction);
        if (!(fClone instanceof IModelFunction)) {
            throw new RuntimeException("Fitter for now can only use IModelFunctions. Please report this problem");
        }
        IModelFunction f = (IModelFunction)fClone;
        this.loadFitDataAndFunction(d, f);
        long startFit = System.currentTimeMillis();
        this.optimizer.optimize();
        long endFit = System.currentTimeMillis();
        double fitSeconds = (double)(endFit - startFit) / 1000.0;
        double[][] covMatrix = this.optimizer.result().covarianceMatrix();
        int status = this.optimizer.result().optimizationStatus();
        int dataEntries = ((FitFunction)this.fitFunction).dataEntries();
        int freePars = ((FitFunction)this.fitFunction).nFreePars();
        int nDoF = dataEntries - freePars;
        double funcVal = this.fitFunction.value(f.parameters());
        FitResult result = new FitResult(this.fitFunction.dimension(), fitSeconds);
        result.setConstraints(this.constraints());
        result.setDataDescription(d.dataDescription());
        result.setEngineName(this.engineName());
        result.setFitMethodName(this.fitMethodName());
        result.setFitStatus(status);
        result.setFittedFunction((IFunction)f);
        result.setIsValid(true);
        result.setNdf(nDoF);
        result.setQuality(funcVal / (double)nDoF);
        int countI = 0;
        String[] parNames = f.parameterNames();
        for (int i = 0; i < parNames.length; ++i) {
            result.setFitParameterSettings(parNames[i], this.fitParameterSettings(parNames[i]));
            int countJ = 0;
            for (int j = 0; j < parNames.length; ++j) {
                if (this.optimizer.variableSettings(parNames[i]).isFixed() || this.optimizer.variableSettings(parNames[j]).isFixed()) continue;
                result.setCovMatrixElement(i, j, covMatrix[countI][countJ++]);
            }
            if (this.optimizer.variableSettings(parNames[i]).isFixed()) continue;
            ++countI;
        }
        return result;
    }

    public IFitResult fit(IBaseHistogram h, IFunction f) {
        FitData fitData = new FitData();
        if (h instanceof IHistogram) {
            if (this.fitMethod.fitType() == 1) {
                throw new IllegalArgumentException("Cannot perform unbinned fit on a IHistogram!!");
            }
            switch (h.dimension()) {
                case 1: {
                    fitData.create1DConnection((IHistogram1D)h);
                    return this.fit((IFitData)fitData, f);
                }
                case 2: {
                    fitData.create2DConnection((IHistogram2D)h);
                    return this.fit((IFitData)fitData, f);
                }
                case 3: {
                    fitData.create3DConnection((IHistogram3D)h);
                    return this.fit((IFitData)fitData, f);
                }
            }
        } else if (h instanceof ICloud) {
            if (this.fitMethod.fitType() == 0) {
                throw new IllegalArgumentException("Cannot perform binned fit on a ICloud!!");
            }
            switch (h.dimension()) {
                case 1: {
                    fitData.create1DConnection((ICloud1D)h);
                    return this.fit((IFitData)fitData, f);
                }
                case 2: {
                    fitData.create2DConnection((ICloud2D)h);
                    return this.fit((IFitData)fitData, f);
                }
                case 3: {
                    fitData.create3DConnection((ICloud3D)h);
                    return this.fit((IFitData)fitData, f);
                }
            }
        } else if (h instanceof IProfile) {
            if (this.fitMethod.fitType() == 1) {
                throw new IllegalArgumentException("Cannot perform unbinned fit on a IProfile!!");
            }
            switch (h.dimension()) {
                case 1: {
                    fitData.create1DConnection((IProfile1D)h);
                    return this.fit((IFitData)fitData, f);
                }
                case 2: {
                    fitData.create2DConnection((IProfile2D)h);
                    return this.fit((IFitData)fitData, f);
                }
            }
        }
        throw new IllegalArgumentException("Something went wrong here!!!! Report this problem!");
    }

    public IFitResult fit(IBaseHistogram h, String model) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        return this.fit(h, func);
    }

    public IFitResult fit(IBaseHistogram h, String model, double[] initialParameters) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        if (initialParameters.length != func.numberOfParameters()) {
            throw new IllegalArgumentException("Wrong number of parameters " + initialParameters.length + "! This function requires " + func.numberOfParameters());
        }
        func.setParameters(initialParameters);
        return this.fit(h, func);
    }

    public IFitResult fit(IDataPointSet dataPointSet, IFunction f) {
        FitData fitData = new FitData();
        if (this.fitMethod.fitType() == 1) {
            throw new IllegalArgumentException("Cannot perform unbinned fit on a IDataPointSet!!");
        }
        if (dataPointSet.dimension() != f.dimension() + 1) {
            throw new IllegalArgumentException("Wrong dimension match. DataPointSets can only be fitted if their dimension is one unit bigger than the one of the function");
        }
        int[] indeces = new int[f.dimension()];
        for (int i = 0; i < f.dimension(); ++i) {
            indeces[i] = i;
        }
        int valIndex = f.dimension();
        fitData.createConnection(dataPointSet, indeces, valIndex);
        return this.fit((IFitData)fitData, f);
    }

    public IFitResult fit(IDataPointSet dataPointSet, String model) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        return this.fit(dataPointSet, func);
    }

    public IFitResult fit(IDataPointSet dataPointSet, String model, double[] initialParameters) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        if (initialParameters.length != func.numberOfParameters()) {
            throw new IllegalArgumentException("Wrong number of parameters " + initialParameters.length + "! This function requires " + func.numberOfParameters());
        }
        func.setParameters(initialParameters);
        return this.fit(dataPointSet, func);
    }

    public IFitResult fit(IFitData d, String model, double[] initialParameters) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        if (initialParameters.length != func.numberOfParameters()) {
            throw new IllegalArgumentException("Wrong number of parameters " + initialParameters.length + "! This function requires " + func.numberOfParameters());
        }
        func.setParameters(initialParameters);
        return this.fit(d, func);
    }

    public IFitResult fit(IFitData d, String model) {
        IFunction func = FunctionCatalog.getFunctionCatalog().create(model);
        return this.fit(d, func);
    }

    public void setConstraint(String expression) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(expression, "=");
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("Only constraints of the form \" parName = SomeExpression \" are supported");
        }
        String parName = st.nextToken().trim();
        if (!Pattern.matches("\\w+", parName)) {
            throw new IllegalArgumentException("Incorrect parameter name " + parName);
        }
        String constrExpression = st.nextToken().trim();
        if (!Pattern.matches("\\w+", constrExpression)) {
            throw new IllegalArgumentException("This type of constraint is not supported yet " + parName + " = " + constrExpression);
        }
        this.simpleConstraintHash.put(parName, constrExpression);
        this.constraintList.add(expression);
    }

    public String[] constraints() {
        int size = this.constraintList.size();
        String[] constraints = new String[size];
        for (int i = 0; i < size; ++i) {
            constraints[i] = (String)this.constraintList.get(i);
        }
        return constraints;
    }

    public void resetConstraints() {
        this.simpleConstraintHash.clear();
        this.constraintList.clear();
    }

    public IDataPointSet createScan1D(IFitData d, IFunction originalFunction, String parName, int npts, double pmin, double pmax) {
        if (pmin > pmax) {
            throw new IllegalArgumentException("Incorret parameter limits : " + pmin + " has to be less than " + pmax);
        }
        if (npts < 1) {
            throw new IllegalArgumentException("The number of points has to be greater than zero : " + npts);
        }
        IFunction fClone = FunctionCatalog.getFunctionCatalog().getFunctionCreator().clone(null, originalFunction);
        if (!(fClone instanceof IModelFunction)) {
            throw new RuntimeException("Fitter for now can only use IModelFunctions. Please report this problem");
        }
        IModelFunction f = (IModelFunction)fClone;
        this.loadFitDataAndFunction(d, f);
        int index = f.indexOfParameter(parName);
        IFitParameterSettings fitParSet = this.fitParameterSettings(parName);
        if (fitParSet.isFixed()) {
            throw new IllegalArgumentException("Parameter " + parName + " is fixed");
        }
        DataPointSet dps = new DataPointSet("", parName + " scan", 2, npts);
        double step = (pmax - pmin) / (double)(npts - 1);
        double startValue = this.optimizer.variableSettings(parName).value();
        for (int i = 0; i < npts; ++i) {
            double val = pmin + (double)i * step;
            if (i == npts - 1) {
                val = pmax;
            }
            this.optimizer.variableSettings(parName).setValue(val);
            String[] parNames = f.parameterNames();
            double[] fitParsVal = new double[parNames.length];
            for (int j = 0; j < parNames.length; ++j) {
                fitParsVal[j] = this.optimizer.variableSettings(parNames[j]).value();
            }
            dps.point(i).coordinate(0).setValue(val);
            dps.point(i).coordinate(0).setErrorPlus(0.0);
            dps.point(i).coordinate(0).setErrorMinus(0.0);
            dps.point(i).coordinate(1).setValue(this.fitFunction.value(fitParsVal));
            dps.point(i).coordinate(1).setErrorPlus(0.0);
            dps.point(i).coordinate(1).setErrorMinus(0.0);
        }
        this.optimizer.variableSettings(parName).setValue(startValue);
        f.setParameter(parName, startValue);
        return dps;
    }

    public IDataPointSet createContour(IFitData d, IFitResult r, String par1, String par2, int npts, double nSigmas) {
        String eName = this.engineName();
        this.setEngine("minuit");
        this.loadFitDataAndFunction(d, (IModelFunction)r.fittedFunction());
        double[][] contour = ((MinuitOptimizer)this.optimizer).calculateContour(par1, par2, npts, nSigmas);
        int found = contour[0].length;
        DataPointSet dps = new DataPointSet("", par1 + " vs " + par2 + " " + nSigmas + " sigma contour", 2, found);
        for (int i = 0; i < found; ++i) {
            dps.point(i).coordinate(0).setValue(contour[0][i]);
            dps.point(i).coordinate(0).setErrorPlus(0.0);
            dps.point(i).coordinate(0).setErrorMinus(0.0);
            dps.point(i).coordinate(1).setValue(contour[1][i]);
            dps.point(i).coordinate(1).setErrorPlus(0.0);
            dps.point(i).coordinate(1).setErrorMinus(0.0);
        }
        this.setEngine(eName);
        return dps;
    }

    private IFunction fitFunction() {
        return this.fitFunction;
    }

    public boolean useFunctionGradient() {
        return this.useGradient;
    }

    public void setUseFunctionGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    private void loadFitDataAndFunction(IFitData d, IModelFunction f) {
        if (this.fitMethod.fitType() != ((IDevFitData)d).fitType()) {
            throw new IllegalArgumentException("This FitData is incompatible with the selected fit method");
        }
        if (d.dimension() != f.dimension()) {
            throw new IllegalArgumentException("Dimension mismatch!! Function's dimension " + f.dimension() + " FitData's dimension " + d.dimension());
        }
        this.optimizer.reset();
        if (this.fitMethod.fitType() == 0) {
            this.optimizer.configuration().setErrorDefinition(1);
            f.normalize(false);
        } else {
            this.optimizer.configuration().setErrorDefinition(2);
            f.normalize(true);
        }
        IRangeSet d_rs = null;
        IRangeSet f_rs = null;
        double[] lb = null;
        double[] ub = null;
        f.excludeNormalizationAll();
        for (int i = 0; i < d.dimension(); ++i) {
            d_rs = d.range(i);
            f_rs = f.normalizationRange(i);
            lb = d_rs.lowerBounds();
            ub = d_rs.upperBounds();
            if (lb.length == 0) {
                throw new RuntimeException("No ranges are set in the FitData. Please report the problem");
            }
            for (int j = 0; j < ub.length; ++j) {
                f_rs.include(lb[j], ub[j]);
            }
        }
        IDevFitDataIterator dataIter = ((IDevFitData)d).dataIterator();
        this.fitFunction = new FitFunction(dataIter, f);
        String[] parNames = f.parameterNames();
        for (int i = 0; i < parNames.length; ++i) {
            double stepSize;
            String parName = parNames[i];
            IFitParameterSettings fitPar = this.fitParameterSettings(parName);
            double parVal = f.parameter(parName);
            IVariableSettings varSet = this.optimizer.variableSettings(parName);
            varSet.setValue(parVal);
            varSet.setFixed(fitPar.isFixed());
            String simpleConstrString = (String)this.simpleConstraintHash.get(parName);
            if (simpleConstrString != null && ((FitFunction)this.fitFunction).isValidSimpleConstraint(parName, simpleConstrString)) {
                ((FitFunction)this.fitFunction).setSimpleConstraint(parName, simpleConstrString);
                varSet.setFixed(true);
            }
            if (Double.isNaN(stepSize = fitPar.stepSize())) {
                stepSize = 0.1 * Math.abs(parVal);
            }
            if (stepSize < 1.0) {
                stepSize = 1.0;
            }
            varSet.setStepSize(stepSize);
            if (!fitPar.isBound()) continue;
            varSet.setBounds(fitPar.lowerBound(), fitPar.upperBound());
        }
        this.optimizer.setFunction(this.fitFunction);
        this.optimizer.configuration().setUseFunctionGradient(this.fitFunction.providesGradient() && this.useFunctionGradient());
        this.optimizer.configuration().setMaxIterations(500);
    }

    public static void main(String[] args) throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IFunction f = ff.createFunctionByName("parabola", "p2");
    }

    private class FitFunction
    implements IFunction {
        private IDevFitDataIterator dataIterator;
        private IModelFunction func;
        private ArrayList varSimpleConstraint1;
        private ArrayList varSimpleConstraint2;

        FitFunction(IDevFitDataIterator dataIterator, IModelFunction func) {
            this.dataIterator = dataIterator;
            this.func = func;
            this.varSimpleConstraint1 = new ArrayList();
            this.varSimpleConstraint2 = new ArrayList();
        }

        public int dimension() {
            return this.func.numberOfParameters();
        }

        public double value(double[] x) {
            if (this.varSimpleConstraint1.size() != 0) {
                this.applySimpleConstraint(x);
            }
            this.dataIterator.start();
            this.func.setParameters(x);
            double fitFunctionValue = 0.0;
            while (this.dataIterator.next()) {
                fitFunctionValue += Fitter.this.fitMethod.evaluateSumElement(this.dataIterator, (IFunction)this.func);
            }
            return fitFunctionValue;
        }

        public boolean providesGradient() {
            return this.func.providesParameterGradient();
        }

        public String variableName(int i) {
            return this.func.parameterNames()[i];
        }

        public String[] variableNames() {
            return this.func.parameterNames();
        }

        public int numberOfParameters() {
            return 0;
        }

        public double[] gradient(double[] x) {
            if (this.varSimpleConstraint1.size() != 0) {
                this.applySimpleConstraint(x);
            }
            this.dataIterator.start();
            this.func.setParameters(x);
            double[] fitFunctionGradients = new double[this.dimension()];
            while (this.dataIterator.next()) {
                double[] grad = Fitter.this.fitMethod.evaluateGradientSumElement(this.dataIterator, (IFunction)this.func);
                for (int i = 0; i < this.dimension(); ++i) {
                    int n = i;
                    fitFunctionGradients[n] = fitFunctionGradients[n] + grad[i];
                }
            }
            return fitFunctionGradients;
        }

        public boolean isEqual(IFunction f) {
            throw new UnsupportedOperationException();
        }

        public IAnnotation annotation() {
            throw new UnsupportedOperationException();
        }

        public String codeletString() {
            throw new UnsupportedOperationException();
        }

        public void setParameters(double[] params) {
            throw new UnsupportedOperationException();
        }

        public double[] parameters() {
            throw new UnsupportedOperationException();
        }

        public int indexOfParameter(String name) {
            throw new UnsupportedOperationException();
        }

        public String[] parameterNames() {
            throw new UnsupportedOperationException();
        }

        public void setParameter(String name, double x) {
            throw new UnsupportedOperationException();
        }

        public double parameter(String name) {
            throw new UnsupportedOperationException();
        }

        public void setTitle(String str) {
            throw new UnsupportedOperationException();
        }

        public String title() {
            throw new UnsupportedOperationException();
        }

        protected int nFreePars() {
            int freePars = 0;
            String[] names = this.variableNames();
            for (int i = 0; i < names.length; ++i) {
                IFitParameterSettings fitPar = Fitter.this.fitParameterSettings(names[i]);
                if (fitPar.isFixed()) continue;
                ++freePars;
            }
            return freePars;
        }

        protected int dataEntries() {
            return this.dataIterator.entries();
        }

        protected int indexOfVariable(String varName) {
            return this.func.indexOfParameter(varName);
        }

        protected void setSimpleConstraint(String varName1, String varName2) {
            int ind1 = this.indexOfVariable(varName1);
            int ind2 = this.indexOfVariable(varName2);
            if (ind1 > -1 && ind2 > -1) {
                this.varSimpleConstraint1.add(new Integer(ind1));
                this.varSimpleConstraint2.add(new Integer(ind2));
            }
        }

        protected boolean isValidSimpleConstraint(String varName1, String varName2) {
            int ind1 = this.indexOfVariable(varName1);
            int ind2 = this.indexOfVariable(varName2);
            return ind1 > -1 && ind2 > -1;
        }

        protected void applySimpleConstraint(double[] x) {
            for (int i = 0; i < this.varSimpleConstraint1.size(); ++i) {
                int ind1 = (Integer)this.varSimpleConstraint1.get(i);
                int ind2 = (Integer)this.varSimpleConstraint2.get(i);
                x[ind1] = x[ind2];
            }
        }
    }
}

