/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.event;

import hep.aida.ref.event.AIDAListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AIDAObservable {
    private List listeners;
    private Map hash;
    protected boolean isValid = false;
    private boolean isValidAfterNotify = false;
    private EventObject theEvent;

    protected AIDAObservable() {
    }

    protected void setIsValidAfterNotify(boolean value) {
        this.isValidAfterNotify = value;
    }

    public synchronized void addListener(AIDAListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
        if (this.theEvent == null) {
            this.theEvent = this.createEvent();
        }
        if (this.hash == null) {
            this.hash = new HashMap();
        }
        this.hash.put(l, new Boolean(true));
        this.isValid = true;
    }

    public synchronized void removeListener(AIDAListener l) {
        this.listeners.remove(l);
        this.hash.remove(l);
        if (this.listeners.isEmpty()) {
            this.isValid = false;
        }
    }

    public void setValid(AIDAListener l) {
        this.hash.put(l, new Boolean(true));
        this.isValid = true;
    }

    protected EventObject createEvent() {
        return new EventObject(this);
    }

    protected void fireStateChanged() {
        this.fireStateChanged(this.theEvent);
    }

    protected synchronized void fireStateChanged(EventObject event) {
        this.isValid = this.isValidAfterNotify;
        if (this.listeners != null) {
            int i = this.listeners.size();
            while (i-- > 0) {
                AIDAListener l = (AIDAListener)this.listeners.get(i);
                boolean listenerValid = (Boolean)this.hash.get(l);
                if (!listenerValid) continue;
                l.stateChanged(event);
                this.hash.put(l, new Boolean(this.isValidAfterNotify));
            }
        }
    }
}

