/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AidaUtils {
    private static Pattern pattern = Pattern.compile("(\\w+)\\s*((=\\s*(\"(.*?)\"|(\\w*)))\\s*)?(,|;|$)");

    public static Map parseOptions(String options) {
        if (options == null || options.trim().length() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> hashValues = new HashMap<String, String>();
        Matcher matcher = pattern.matcher(options);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(5);
            if (value == null) {
                value = matcher.group(6);
            }
            if (value == null) {
                value = "true";
            }
            hashValues.put(key, value);
            if (matcher.end() != options.length()) continue;
            return hashValues;
        }
        throw new IllegalArgumentException("Invalid options: " + options);
    }
}

