/*
 * Decompiled with CFR 0.152.
 */
package TestGUI;

import GuiComponents.System.SystemInterface;
import Sct.IS.SctNames;
import Sct_CalibrationController.CalibrationController;
import Sct_CalibrationController.CalibrationControllerStatus;
import Sct_CalibrationController.SequenceRequest;
import Sct_CalibrationController.TestRequest;
import TestGUI.ExampleSequenceRequest;
import TestGUI.ExampleTestRequest;
import ipc.Core;
import ipc.Info;
import ipc.InfoHolder;
import is.InfoEvent;
import is.InfoListener;
import is.InfoNotCompatibleException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class CalibrationControllerPanel
extends JPanel
implements InfoListener {
    private JButton bCharacter;
    private JButton bNMask;
    private JButton bPing;
    private JButton bRefresh;
    private JButton bResponse;
    private JButton bStrobeDelay;
    private JButton bThreePt;
    private JButton bThreshold;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTable tStatus;
    private JTextArea taMessages;
    private SystemInterface si;
    static /* synthetic */ Class class$java$lang$String;

    public CalibrationControllerPanel(JTextArea jTextArea) {
        this.taMessages = jTextArea;
        this.si = SystemInterface.getInstance();
        this.initComponents();
        this.myInitComponents();
    }

    private void myInitComponents() {
        try {
            CalibrationControllerStatus calibrationControllerStatus = new CalibrationControllerStatus();
            SctNames.getISRepository().getValue(SctNames.getControlISServer() + ".Status", (is.Info)calibrationControllerStatus);
            this.updateStatus(calibrationControllerStatus);
        }
        catch (RuntimeException runtimeException) {
            this.taMessages.append("Couldn't get CalibrationController Status: " + runtimeException.getMessage() + "\n");
            this.updateStatus(null);
        }
        try {
            SctNames.getISRepository().subscribe(SctNames.getControlISServer(), "Status", false, (InfoListener)this);
        }
        catch (RuntimeException runtimeException) {
            this.taMessages.append("Couldn't subscribe to ControlData IS Server: " + runtimeException.getMessage() + "\n");
        }
    }

    void close() {
        try {
            SctNames.getISRepository().unsubscribe(SctNames.getControlISServer(), "Status", false);
        }
        catch (RuntimeException runtimeException) {
            this.taMessages.append("Couldn't unsubscribe from ControlData IS Server: " + runtimeException.getMessage() + "\n");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.bRefresh = new JButton();
        this.tStatus = new JTable();
        this.jLabel1 = new JLabel();
        this.bPing = new JButton();
        this.jPanel2 = new JPanel();
        this.bCharacter = new JButton();
        this.bResponse = new JButton();
        this.bThreshold = new JButton();
        this.jButton1 = new JButton();
        this.bStrobeDelay = new JButton();
        this.bNMask = new JButton();
        this.bThreePt = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Calibration Controller"));
        this.bRefresh.setText("Refresh");
        this.bRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bRefreshActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.bRefresh, gridBagConstraints);
        this.tStatus.setBorder(new EtchedBorder());
        this.tStatus.setModel(new DefaultTableModel(new Object[][]{{"Status", "UNAVAILABLE"}, {"Current Sequence", null}, {"Current Test", null}, {"Current Scan Index", null}}, new String[]{"Name", "Value"}){
            Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CalibrationControllerPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CalibrationControllerPanel.class$("java.lang.String")) : class$java$lang$String};
            boolean[] canEdit = new boolean[]{false, false};

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.tStatus.setIntercellSpacing(new Dimension(5, 5));
        this.tStatus.setMinimumSize(new Dimension(200, 80));
        this.tStatus.setPreferredSize(new Dimension(300, 80));
        this.tStatus.setRowHeight(20);
        this.tStatus.setShowHorizontalLines(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.tStatus, gridBagConstraints);
        this.jLabel1.setText("Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.bPing.setText("Ping");
        this.bPing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bPingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.bPing, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(new TitledBorder("Sequences, Tests and Scans"));
        this.bCharacter.setText("Characterization Sequence");
        this.bCharacter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bCharacterActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bCharacter);
        this.bResponse.setText("Response Curve");
        this.bResponse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bResponseActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bResponse);
        this.bThreshold.setText("ExampleTestRequest");
        this.bThreshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bThresholdActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bThreshold);
        this.jButton1.setText("ExampleSequenceRequest");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.bStrobeDelay.setText("StrobeDelay");
        this.bStrobeDelay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bStrobeDelayActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bStrobeDelay);
        this.bNMask.setText("NMask");
        this.bNMask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bNMaskActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bNMask);
        this.bThreePt.setText("ThreePointGain");
        this.bThreePt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalibrationControllerPanel.this.bThreePtActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.bThreePt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void bThreePtActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        calibrationController.doTest(calibrationController.getTestLibrary().threePointGain());
    }

    private void bNMaskActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        calibrationController.doTest(calibrationController.getTestLibrary().nmask());
    }

    private void bStrobeDelayActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        calibrationController.doTest(calibrationController.getTestLibrary().strobeDelay());
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        ExampleSequenceRequest exampleSequenceRequest = new ExampleSequenceRequest(calibrationController);
        SequenceRequest sequenceRequest = exampleSequenceRequest._this(Core.getORB());
        calibrationController.doSequence(sequenceRequest);
    }

    private void bThresholdActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        ExampleTestRequest exampleTestRequest = new ExampleTestRequest();
        TestRequest testRequest = exampleTestRequest._this(Core.getORB());
        calibrationController.doTest(testRequest);
    }

    private void bResponseActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        calibrationController.doTest(calibrationController.getTestLibrary().responseCurve());
    }

    private void bCharacterActionPerformed(ActionEvent actionEvent) {
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController == null) {
            this.taMessages.append("No handle to CalibrationController.  Please run and hit refresh\n");
            return;
        }
        calibrationController.doSequence(calibrationController.getSequenceLibrary().characterizationSequence());
    }

    private void bPingActionPerformed(ActionEvent actionEvent) {
        InfoHolder infoHolder = new InfoHolder();
        CalibrationController calibrationController = this.si.getCalibrationController();
        if (calibrationController != null) {
            calibrationController.get_info(infoHolder);
            Info info = infoHolder.value;
            this.taMessages.append("CalibrationController running: " + info.pid + " by " + info.owner + " on " + info.host + " since " + info.time + "\n");
        } else {
            this.taMessages.append("CalibrationController not running\n");
        }
    }

    private void bRefreshActionPerformed(ActionEvent actionEvent) {
        this.si.refresh();
    }

    void updateStatus(CalibrationControllerStatus calibrationControllerStatus) {
        if (calibrationControllerStatus == null) {
            this.tStatus.getModel().setValueAt("UNAVAILABLE", 0, 1);
            this.tStatus.getModel().setValueAt("", 1, 1);
            this.tStatus.getModel().setValueAt("", 2, 1);
            this.tStatus.getModel().setValueAt("", 3, 1);
        } else {
            switch (calibrationControllerStatus.status) {
                case 0: {
                    this.tStatus.getModel().setValueAt("LOADED", 0, 1);
                    break;
                }
                case 1: {
                    this.tStatus.getModel().setValueAt("INCONTROL", 0, 1);
                    break;
                }
                case 2: {
                    this.tStatus.getModel().setValueAt("BUSY", 0, 1);
                    break;
                }
                default: {
                    this.tStatus.getModel().setValueAt("UNKNOWN", 0, 1);
                }
            }
            this.tStatus.getModel().setValueAt(calibrationControllerStatus.currentSequence, 1, 1);
            this.tStatus.getModel().setValueAt(calibrationControllerStatus.currentTest, 2, 1);
            this.tStatus.getModel().setValueAt("" + calibrationControllerStatus.currentScanIndex, 3, 1);
        }
    }

    public void infoCreated(InfoEvent infoEvent) {
        try {
            CalibrationControllerStatus calibrationControllerStatus = new CalibrationControllerStatus();
            infoEvent.getValue((is.Info)calibrationControllerStatus);
            this.updateStatus(calibrationControllerStatus);
        }
        catch (InfoNotCompatibleException infoNotCompatibleException) {
            this.taMessages.append("Unable to read IS object - not a CalibrationControllerStatus: " + infoNotCompatibleException.getMessage() + "\n");
        }
    }

    public void infoDeleted(InfoEvent infoEvent) {
        this.updateStatus(null);
    }

    public void infoUpdated(InfoEvent infoEvent) {
        this.infoCreated(infoEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

