/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import hep.aida.IAxis;
import hep.aida.ref.histogram.VariableAxis;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;

public class ScanPoints
implements Streamable {
    private ArrayList points = new ArrayList();

    public ScanPoints(float[] fArray, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        this.init(fArray, nArray, nArray2);
    }

    public ScanPoints(ScanPoints scanPoints) {
        int n = 0;
        while (n < scanPoints.points.size()) {
            ++n;
        }
    }

    public int getNPoints() {
        return this.points.size();
    }

    public double getPoint(int n) {
        return ((ScanPoint)this.points.get((int)n)).point;
    }

    public int getNEvents(int n) {
        return ((ScanPoint)this.points.get((int)n)).nEvents;
    }

    public int getNErrorEvents(int n) {
        return ((ScanPoint)this.points.get((int)n)).nErrorEvents;
    }

    public void addPoint(double d, int n, int n2) {
        ScanPoint scanPoint = new ScanPoint(d, n, n2);
        this.points.add(scanPoint);
    }

    public IAxis getAxis() {
        if (this.getNPoints() < 2) {
            throw new IllegalStateException("Must have at least 2 points");
        }
        double[] dArray = new double[this.getNPoints() + 1];
        dArray[0] = 1.5 * this.getPoint(0) - 0.5 * this.getPoint(1);
        int n = 1;
        while (n < this.getNPoints()) {
            dArray[n] = 0.5 * (this.getPoint(n - 1) + this.getPoint(n));
            ++n;
        }
        dArray[this.getNPoints()] = 1.5 * this.getPoint(this.getNPoints() - 1) - 0.5 * this.getPoint(this.getNPoints() - 2);
        return new VariableAxis(dArray);
    }

    public String getClassName() {
        return "SctData.ScanPoints";
    }

    public static ScanPoints read(IStream iStream, ObjectManager objectManager) throws IOException {
        short s = iStream.readShort("NPoints");
        float[] fArray = iStream.readFloatArray("Points");
        int[] nArray = iStream.readIntArray("nEvents");
        int[] nArray2 = iStream.readIntArray("nErrorEvents");
        if (s != fArray.length) {
            throw new StreamCorruptedException("Arrays read in were not expected length\nExpected: " + s + " Got: " + fArray.length);
        }
        try {
            return new ScanPoints(fArray, nArray, nArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StreamCorruptedException("Arrays read in were different lengths");
        }
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        int n = this.getNPoints();
        oStream.writeShort("NPoints", (short)n, false);
        float[] fArray = new float[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)this.getPoint(n2);
            nArray[n2] = this.getNEvents(n2);
            nArray2[n2] = this.getNErrorEvents(n2);
            ++n2;
        }
        oStream.writeFloatArray("Points", fArray);
        oStream.writeIntArray("nEvents", nArray, false);
        oStream.writeIntArray("nErrorEvents", nArray2, false);
    }

    private void init(float[] fArray, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        if (fArray.length != nArray.length || fArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arrays must be the same length!!");
        }
        int n = 0;
        while (n < fArray.length) {
            this.addPoint(fArray[n], nArray[n], nArray2[n]);
            ++n;
        }
    }

    private class ScanPoint {
        public double point;
        public int nEvents;
        public int nErrorEvents;

        public ScanPoint(double d, int n, int n2) {
            this.point = d;
            this.nEvents = n;
            this.nErrorEvents = n2;
        }
    }
}

