/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import SctData.ModuleConfiguration;
import SctData.ScanHeader;
import SctData.ScanPoints;
import SctData.ScanResult;
import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram2D;
import java.io.IOException;
import java.io.StreamCorruptedException;

public class RawScanResult
extends ScanResult {
    private static final short SLICE = 2;
    private static final short SCURVE = 4;
    private static final short SLICE_COMPRESSED = 6;
    private static final short SCURVE_COMPRESSED = 8;
    private static final short FIT = 10;
    private static final short HITS_PER_EVENT = 12;
    private static final short ROOTHIST = 14;
    private static final short RAWHIST = 16;
    private static final short WIDTH_64BIT = 64;
    private static final short WIDTH_32BIT = 32;
    private static final short WIDTH_16BIT = 16;
    private IHistogram2D scanData;

    public RawScanResult(ScanHeader scanHeader, ModuleConfiguration moduleConfiguration, ScanPoints scanPoints, IHistogram2D iHistogram2D) {
        super(scanHeader, moduleConfiguration, scanPoints);
        this.scanData = iHistogram2D;
    }

    public String getClassName() {
        return "SctData.RawScanResult";
    }

    public String getUniqueID() {
        return "RawScanResult." + this.header.getUniqueID();
    }

    public static String getUniqueID(ScanHeader scanHeader) {
        return "RawScanResult." + scanHeader.getUniqueID();
    }

    public IHistogram2D getData() {
        return this.scanData;
    }

    public static RawScanResult read(IStream iStream, ObjectManager objectManager) throws IOException {
        return new RawScanResult(iStream, objectManager);
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        int n;
        super.write(oStream, objectManager);
        int n2 = this.getPoints().getNPoints();
        int n3 = 770 * (n2 + 2);
        oStream.writeInt("Size", n3, false);
        oStream.writeShort("Type", (short)14, false);
        oStream.writeShort("Width", (short)64, false);
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int n4 = 0;
        while (n4 < 768) {
            n = 0;
            while (n < n2) {
                dArray[770 * (n + 1) + n4 + 1] = this.scanData.binHeight(n4, n);
                ++n;
            }
            ++n4;
        }
        n = 0;
        while (n < 768) {
            int n5 = 0;
            while (n5 < n2) {
                dArray2[770 * (n5 + 1) + n + 1] = this.scanData.binHeight(n + 768, n5);
                ++n5;
            }
            ++n;
        }
        oStream.writeDoubleArray("Link0Data", dArray);
        oStream.writeDoubleArray("Link1Data", dArray2);
    }

    private RawScanResult(IStream iStream, ObjectManager objectManager) throws IOException {
        super(iStream, objectManager);
        FixedAxis fixedAxis = new FixedAxis(1536, -0.5, 1536.5);
        Histogram2D histogram2D = new Histogram2D(this.getUniqueID(), this.getUniqueID(), fixedAxis, this.getPoints().getAxis());
        this.scanData = histogram2D;
        this.readData(iStream, histogram2D);
    }

    private void readData(IStream iStream, Histogram2D histogram2D) throws IOException {
        int n = iStream.readInt("Size");
        short s = iStream.readShort("Type");
        short s2 = iStream.readShort("Width");
        switch (s) {
            case 2: {
                this.readSliceData(iStream, histogram2D, n, s2);
                return;
            }
            case 14: {
                this.readRootData(iStream, histogram2D, n, s2);
                return;
            }
        }
        throw new StreamCorruptedException("Unsupported raw data type: " + s);
    }

    private void readSliceData(IStream iStream, Histogram2D histogram2D, int n, short s) throws IOException {
    }

    private void readRootData(IStream iStream, Histogram2D histogram2D, int n, short s) throws IOException {
        double[] dArray = iStream.readDoubleArray("Link0Data");
        double[] dArray2 = iStream.readDoubleArray("Link1Data");
        int n2 = this.getPoints().getNPoints();
        if (dArray.length != dArray2.length || dArray.length != 770 * (n2 + 2)) {
            throw new StreamCorruptedException("Data arrays are not correct length.  Expected: " + 770 * (n2 + 2) + " Link0Data length: " + dArray.length + " Link1Data length: " + dArray2.length);
        }
        double[][] dArray3 = new double[1538][n2 + 2];
        double[][] dArray4 = new double[1538][n2 + 2];
        IAxis iAxis = histogram2D.xAxis();
        IAxis iAxis2 = histogram2D.yAxis();
        int n3 = 0;
        while (n3 < 1536) {
            int n4 = 0;
            while (n4 < n2) {
                dArray3[n3 + 1][n4 + 1] = n3 < 768 ? dArray[(n4 + 1) * 770 + n3 + 1] : dArray2[(n4 + 1) * 770 + n3 + 1 - 768];
                dArray4[n3 + 1][n4 + 1] = Math.sqrt(dArray3[n3][n4]);
                ++n4;
            }
            ++n3;
        }
        histogram2D.setContents(dArray3, dArray4, null, null, null, null, null);
    }
}

