/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import java.io.IOException;

public class ModuleElement
implements Streamable {
    private int first;
    private int last;

    public ModuleElement(int n, int n2) throws IllegalArgumentException {
        if (n2 >= 1536 || n2 < n) {
            throw new IllegalArgumentException("Unable to create ModuleElement with parameters first: " + n + " last: " + n2);
        }
        this.first = n;
        this.last = n2;
    }

    public static ModuleElement chip(int n) {
        return new ModuleElement(n * 128, (n + 1) * 128 - 1);
    }

    public static ModuleElement channel(int n) {
        return new ModuleElement(n, n);
    }

    public static ModuleElement link(int n) {
        return new ModuleElement(n * 768, (n + 1) * 768 - 1);
    }

    public static ModuleElement module() {
        return new ModuleElement(0, 1535);
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int getNChannels() {
        return this.last - this.first + 1;
    }

    public boolean isChannel() {
        return this.getNChannels() == 1;
    }

    public boolean isChip() {
        return this.getFirst() % 128 == 0 && this.getNChannels() == 128;
    }

    public boolean isLink() {
        return this.getFirst() % 768 == 0 && this.getNChannels() == 768;
    }

    public boolean isModule() {
        return this.getFirst() % 1536 == 0 && this.getNChannels() == 1536;
    }

    public boolean equals(Object object) {
        if (object instanceof ModuleElement) {
            ModuleElement moduleElement = (ModuleElement)object;
            return this.getFirst() == moduleElement.getFirst() && this.getLast() == moduleElement.getLast();
        }
        return false;
    }

    public boolean superset(ModuleElement moduleElement) {
        return this.getFirst() <= moduleElement.getFirst() && this.getLast() >= moduleElement.getLast();
    }

    public boolean subset(ModuleElement moduleElement) {
        return this.getFirst() >= moduleElement.getFirst() && this.getLast() <= moduleElement.getLast();
    }

    public boolean overlaps(ModuleElement moduleElement) {
        return this.getFirst() <= moduleElement.getLast() && this.getFirst() >= moduleElement.getFirst() || this.getLast() <= moduleElement.getLast() && this.getLast() >= moduleElement.getFirst();
    }

    public String getClassName() {
        return "SctData.ModuleElement";
    }

    public static ModuleElement read(IStream iStream, ObjectManager objectManager) throws IOException {
        int n = iStream.readInt("FirstChannel");
        int n2 = iStream.readInt("LastChannel");
        return new ModuleElement(n, n2);
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeInt("FirstChannel", this.first, false);
        oStream.writeInt("LastChannel", this.last, false);
    }
}

