/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import SctData.ModuleDefect;
import SctData.ModuleElement;
import java.io.IOException;
import java.util.ArrayList;

public class ModuleDefectList
implements Streamable {
    private ArrayList defectList = new ArrayList();

    public void addDefect(ModuleDefect moduleDefect) throws IllegalArgumentException {
        if (moduleDefect == null || moduleDefect.isPrototype()) {
            throw new IllegalArgumentException("May not add prototypical ModuleDefects to a ModuleDefectList");
        }
        this.defectList.add(moduleDefect);
    }

    public int size() {
        return this.defectList.size();
    }

    public ModuleDefect get(int n) {
        return (ModuleDefect)this.defectList.get(n);
    }

    public ModuleDefectList getDefectsAffectingElement(ModuleElement moduleElement) {
        ModuleDefectList moduleDefectList = new ModuleDefectList();
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n);
            if (moduleDefect.getModuleElement().overlaps(moduleElement)) {
                moduleDefectList.addDefect(moduleDefect);
            }
            ++n;
        }
        return moduleDefectList;
    }

    public int getNDefectsAffectingElement(ModuleElement moduleElement) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n2);
            if (moduleDefect.getModuleElement().overlaps(moduleElement)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean severeDefectAffectingElement(ModuleElement moduleElement) {
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n);
            if (moduleDefect.isSevere()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean defectAffectingElement(ModuleElement moduleElement) {
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n);
            if (moduleDefect.getModuleElement().overlaps(moduleElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean defectAffectingElement(ModuleElement moduleElement, ModuleDefect moduleDefect) {
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect2 = this.get(n);
            if (moduleDefect2.isSameTypeAs(moduleDefect) && moduleDefect2.getModuleElement().overlaps(moduleElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ModuleDefectList getDefectsEncompassingElement(ModuleElement moduleElement) {
        ModuleDefectList moduleDefectList = new ModuleDefectList();
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n);
            if (moduleDefect.getModuleElement().superset(moduleElement)) {
                moduleDefectList.addDefect(moduleDefect);
            }
            ++n;
        }
        return moduleDefectList;
    }

    public int getNDefectsEncompassingElement(ModuleElement moduleElement) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n2);
            if (moduleDefect.getModuleElement().superset(moduleElement)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean severeDefectEncompassingElement(ModuleElement moduleElement) {
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n);
            if (moduleDefect.isSevere() && moduleDefect.getModuleElement().superset(moduleElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean defectEncompassingElement(ModuleElement moduleElement) {
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect = this.get(n);
            if (moduleDefect.getModuleElement().superset(moduleElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean defectEncompassingElement(ModuleElement moduleElement, ModuleDefect moduleDefect) {
        int n = 0;
        while (n < this.defectList.size()) {
            ModuleDefect moduleDefect2 = this.get(n);
            if (moduleDefect2.isSameTypeAs(moduleDefect) && moduleDefect2.getModuleElement().superset(moduleElement)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getClassName() {
        return "SctData.ModuleDefectList";
    }

    public void add(ModuleDefectList moduleDefectList) {
        this.defectList.addAll(moduleDefectList.defectList);
    }

    public static ModuleDefectList read(IStream iStream, ObjectManager objectManager) throws IOException {
        ModuleDefectList moduleDefectList = new ModuleDefectList();
        int n = iStream.readInt("NDefects");
        int n2 = 0;
        while (n2 < n) {
            ModuleDefect moduleDefect = (ModuleDefect)objectManager.readObject(iStream, "Defect", "SctData.ModuleDefect");
            moduleDefectList.addDefect(moduleDefect);
            ++n2;
        }
        return moduleDefectList;
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeInt("NDefects", this.size(), false);
        int n = 0;
        while (n < this.size()) {
            objectManager.writeObject(oStream, "Defect", this.get(n), false);
            ++n;
        }
    }
}

