/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import SctData.ChipConfiguration;
import java.io.IOException;
import sctConf.ABCDBasic;
import sctConf.ABCDCaldata;
import sctConf.ABCDChip;
import sctConf.ABCDConfig;
import sctConf.ABCDModule;

public class ModuleConfiguration
implements Streamable {
    private ABCDModule data;
    private ChipConfiguration[] chips = new ChipConfiguration[12];

    public ModuleConfiguration() {
        this.data = new ABCDModule();
        this.data.chip = new ABCDChip[12];
        int n = 0;
        while (n < this.data.chip.length) {
            this.data.chip[n] = new ABCDChip();
            this.data.chip[n].basic = new ABCDBasic();
            this.data.chip[n].caldata = new ABCDCaldata();
            this.data.chip[n].trim = new byte[128];
            this.data.chip[n].caldata.rc_params = new float[3];
            this.data.chip[n].basic.config = new ABCDConfig();
            this.data.chip[n].basic.mask = new int[4];
            ++n;
        }
        this.data.rx = new byte[4];
        int n2 = 0;
        while (n2 < this.chips.length) {
            this.chips[n2] = new ChipConfiguration(this.data.chip[n2]);
            ++n2;
        }
    }

    public ModuleConfiguration(ABCDModule aBCDModule) {
        this.data = aBCDModule;
        int n = 0;
        while (n < this.chips.length) {
            this.chips[n] = new ChipConfiguration(aBCDModule.chip[n]);
            ++n;
        }
    }

    public ABCDModule getData() {
        return this.data;
    }

    public ChipConfiguration getChipConfiguration(int n) {
        return this.chips[n];
    }

    public boolean isPresent() {
        return this.data.present != 0;
    }

    public boolean isActive() {
        return this.data.active != 0;
    }

    public void setActive(boolean bl) {
        this.data.active = bl ? (byte)1 : 0;
    }

    public boolean usingPrimaryClock() {
        return this.data.select != 0;
    }

    public void setUsingPrimaryClock(boolean bl) {
        this.data.select = bl ? (byte)1 : 0;
    }

    public boolean channelIsMasked(int n) {
        return this.getChipConfiguration(n / 128).isMasked(n % 128);
    }

    public void maskChannel(int n) {
        this.getChipConfiguration(n / 128).mask(n % 128);
    }

    public byte getGroupId() {
        return this.data.groupId;
    }

    public void setGroupId(byte by) {
        this.data.groupId = by;
    }

    public String getClassName() {
        return "SctData.ModuleConfiguration";
    }

    public static Streamable read(IStream iStream, ObjectManager objectManager) throws IOException {
        ModuleConfiguration moduleConfiguration = new ModuleConfiguration();
        int n = 0;
        while (n < moduleConfiguration.chips.length) {
            moduleConfiguration.chips[n] = (ChipConfiguration)objectManager.readObject(iStream, "ChipConfiguration", "SctData.ChipConfiguration");
            moduleConfiguration.data.chip[n] = moduleConfiguration.chips[n].getData();
            ++n;
        }
        moduleConfiguration.data.present = iStream.readByte("Present");
        moduleConfiguration.data.active = iStream.readByte("Active");
        moduleConfiguration.data.select = iStream.readByte("Select");
        moduleConfiguration.data.groupId = iStream.readByte("GroupId");
        moduleConfiguration.data.pTTC = iStream.readByte("pTTC");
        moduleConfiguration.data.rTTC = iStream.readByte("rTTC");
        moduleConfiguration.data.rx = iStream.readByteArray("rx");
        return moduleConfiguration;
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        int n = 0;
        while (n < this.chips.length) {
            objectManager.writeObject(oStream, "ChipConfiguration", this.chips[n], false);
            ++n;
        }
        oStream.writeByte("Present", this.data.present, false);
        oStream.writeByte("Active", this.data.active, false);
        oStream.writeByte("Select", this.data.select, false);
        oStream.writeByte("GroupId", this.data.groupId, false);
        oStream.writeByte("pTTC", this.data.pTTC, false);
        oStream.writeByte("rTTC", this.data.rTTC, false);
        oStream.writeByteArray("rx", this.data.rx, false);
    }
}

