/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import java.io.IOException;
import sctConf.ABCDConfig;

public class ChipOptions
implements Streamable {
    private ABCDConfig data;

    public ChipOptions(ABCDConfig aBCDConfig) {
        this.data = aBCDConfig;
    }

    public String getClassName() {
        return "SctData.ChipOptions";
    }

    public ABCDConfig getData() {
        return this.data;
    }

    public byte getReadOutMode() {
        return this.getDoubleBit(14);
    }

    public void setReadOutMode(byte by) {
        if (by > 3) {
            throw new IllegalArgumentException("Readout mode must be below 4.  Given: " + by);
        }
        this.setDoubleBit(by, 14);
    }

    public byte getCalibMode() {
        return this.getDoubleBit(12);
    }

    public void setCalibMode(byte by) {
        if (by > 3) {
            throw new IllegalArgumentException("Cali mode must be below 4.  Given: " + by);
        }
        this.setDoubleBit(by, 12);
    }

    public byte getTrimRange() {
        return this.getDoubleBit(10);
    }

    public void setTrimRange(byte by) {
        if (by > 3) {
            throw new IllegalArgumentException("Trim Range must be below 4.  Given: " + by);
        }
        this.setDoubleBit(by, 10);
    }

    public boolean getEdgeDetect() {
        return this.getBit(9);
    }

    public void setEdgeDetect(boolean bl) {
        this.setBit(bl, 9);
    }

    public boolean getMaskFlag() {
        return this.getBit(8);
    }

    public void setMaskFlag(boolean bl) {
        this.setBit(bl, 8);
    }

    public boolean getAccumulate() {
        return this.getBit(7);
    }

    public void setAccumulate(boolean bl) {
        this.setBit(bl, 7);
    }

    public boolean getInputBypass() {
        return this.getBit(6);
    }

    public void setInputBypass(boolean bl) {
        this.setBit(bl, 6);
    }

    public boolean getOutputBypass() {
        return this.getBit(5);
    }

    public void setOutputBypass(boolean bl) {
        this.setBit(bl, 5);
    }

    public boolean getMaster() {
        return this.getBit(4);
    }

    public void setMaster(boolean bl) {
        this.setBit(bl, 4);
    }

    public boolean getEnd() {
        return this.getBit(3);
    }

    public void setEnd(boolean bl) {
        this.setBit(bl, 3);
    }

    public boolean getFeedThrough() {
        return this.getBit(2);
    }

    public void setFeedThrough(boolean bl) {
        this.setBit(bl, 2);
    }

    public static Streamable read(IStream iStream, ObjectManager objectManager) throws IOException {
        ChipOptions chipOptions = new ChipOptions(new ABCDConfig());
        chipOptions.readObject(iStream, objectManager);
        return chipOptions;
    }

    public void readObject(IStream iStream, ObjectManager objectManager) throws IOException {
        this.setReadOutMode((byte)iStream.readShort("ReadoutMode"));
        this.setCalibMode((byte)iStream.readShort("CalibMode"));
        this.setTrimRange((byte)iStream.readShort("TrimRange"));
        this.setEdgeDetect(iStream.readShort("EdgeDetect") != 0);
        this.setMaskFlag(iStream.readShort("Mask") != 0);
        this.setAccumulate(iStream.readShort("Accumulate") != 0);
        this.setInputBypass(iStream.readShort("InputBypass") != 0);
        this.setOutputBypass(iStream.readShort("OutputBypass") != 0);
        this.setMaster(iStream.readShort("Master") != 0);
        this.setEnd(iStream.readShort("End") != 0);
        this.setFeedThrough(iStream.readShort("FeedThrough") != 0);
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeShort("ReadoutMode", this.getReadOutMode(), false);
        oStream.writeShort("CalibMode", this.getCalibMode(), false);
        oStream.writeShort("TrimRange", this.getTrimRange(), false);
        oStream.writeShort("EdgeDetect", this.getEdgeDetect() ? (short)1 : 0, false);
        oStream.writeShort("Mask", this.getMaskFlag() ? (short)1 : 0, false);
        oStream.writeShort("Accumulate", this.getAccumulate() ? (short)1 : 0, false);
        oStream.writeShort("InputBypass", this.getInputBypass() ? (short)1 : 0, false);
        oStream.writeShort("OutputBypass", this.getOutputBypass() ? (short)1 : 0, false);
        oStream.writeShort("Master", this.getMaster() ? (short)1 : 0, false);
        oStream.writeShort("End", this.getEnd() ? (short)1 : 0, false);
        oStream.writeShort("FeedThrough", this.getFeedThrough() ? (short)1 : 0, false);
    }

    private void setDoubleBit(byte by, int n) {
        this.data.bitField = (short)(this.data.bitField & ~(3 << n) | by << n);
    }

    private byte getDoubleBit(int n) {
        return (byte)(this.data.bitField >> n & 3);
    }

    private void setBit(boolean bl, int n) {
        this.data.bitField = bl ? (short)(this.data.bitField | 1 << n) : (short)(this.data.bitField & ~(1 << n));
    }

    private boolean getBit(int n) {
        return (this.data.bitField & 1 << n) == 1 << n;
    }
}

