/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DateListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class DateModel {
    private Vector listeners = new Vector();
    private Calendar date;

    DateModel(Calendar calendar) {
        this.date = calendar;
    }

    DateModel(Date date) {
        this.date = Calendar.getInstance();
        this.date.setTime(date);
    }

    synchronized void addDateListener(DateListener dateListener) {
        this.listeners.addElement(dateListener);
    }

    synchronized void removeDateListener(DateListener dateListener) {
        this.listeners.removeElement(dateListener);
    }

    synchronized void fireDateChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DateListener dateListener = (DateListener)enumeration.nextElement();
            dateListener.dateChanged();
        }
    }

    void set(int n, int n2) {
        this.date.set(n, n2);
        this.fireDateChanged();
    }

    void roll(int n, boolean bl) {
        this.date.roll(n, bl);
        this.fireDateChanged();
    }

    void add(int n, int n2) {
        this.date.add(n, n2);
        this.fireDateChanged();
    }

    int get(int n) {
        return this.date.get(n);
    }

    Calendar getCalendar() {
        return this.date;
    }

    int getDaysInMonth() {
        Calendar calendar = (Calendar)this.date.clone();
        calendar.add(5, 31);
        return 31 - calendar.get(5) + this.date.get(5);
    }

    Date getTime() {
        return this.date.getTime();
    }
}

