/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHistScatterPlotStyle;
import jas.hist.JASHistStyle;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.test.MyCustomOverlay;
import java.util.Observable;
import java.util.Random;

public class TestCustomOverlay
extends Observable
implements ScatterPlotSource,
HasStyle,
Runnable {
    private double[] values = new double[100];
    private double[] times = new double[100];
    private int maxPoint = 0;
    private double xmin = 0.0;
    private double xmax = 0.0;
    private static final HistogramUpdate hdr = new HistogramUpdate(6, true);
    protected double[] x;
    protected double[] y;
    private Random random = new Random();

    public TestCustomOverlay() {
        hdr.setAxis(TestCustomOverlay.hdr.HORIZONTAL_AXIS);
        hdr.setAxis(TestCustomOverlay.hdr.VERTICAL_AXIS);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        double d = 0.0;
        double d2 = 0.0;
        try {
            while (true) {
                Thread.sleep(100L);
                if (!(Math.abs((d2 += Math.random() - 0.5) - d) > 2.0)) continue;
                this.addPoint(d2, (double)System.currentTimeMillis() / 1000.0);
                d = d2;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    synchronized void addPoint(double d, double d2) {
        if (this.maxPoint < this.values.length) {
            this.values[this.maxPoint] = d;
            this.times[this.maxPoint] = d2;
            this.xmin = Math.min(this.xmin, d);
            this.xmax = Math.max(this.xmax, d);
            ++this.maxPoint;
        } else {
            this.xmin = this.xmax = this.values[1];
            int n = 1;
            while (n < this.maxPoint) {
                double d3 = this.values[n];
                this.xmin = Math.min(this.xmin, d3);
                this.xmax = Math.max(this.xmax, d3);
                this.values[n - 1] = d3;
                this.times[n - 1] = this.times[n];
                ++n;
            }
            this.values[this.maxPoint - 1] = d;
            this.times[this.maxPoint - 1] = d2;
        }
        this.setChanged();
        this.notifyObservers(hdr);
    }

    public JASHistStyle getStyle() {
        JASHistScatterPlotStyle jASHistScatterPlotStyle = new JASHistScatterPlotStyle();
        jASHistScatterPlotStyle.setCustomOverlay(new MyCustomOverlay());
        return jASHistScatterPlotStyle;
    }

    public ScatterEnumeration startEnumeration(double d, double d2, double d3, double d4) {
        return new CustomEnumeration();
    }

    public ScatterEnumeration startEnumeration() {
        return new CustomEnumeration();
    }

    public double getXMin() {
        return this.times[0];
    }

    public double getXMax() {
        return this.times[this.maxPoint - 1];
    }

    public double getYMin() {
        return this.xmin;
    }

    public double getYMax() {
        return this.xmax;
    }

    public void clearChanges() {
    }

    public int getXAxisType() {
        return 3;
    }

    public int getYAxisType() {
        return 1;
    }

    public String getTitle() {
        return "Custom Overlay";
    }

    private class CustomEnumeration
    implements ScatterEnumeration {
        private int n = 0;

        private CustomEnumeration() {
        }

        public boolean getNextPoint(double[] dArray) {
            if (this.n < TestCustomOverlay.this.maxPoint) {
                dArray[0] = TestCustomOverlay.this.times[this.n];
                dArray[1] = TestCustomOverlay.this.values[this.n];
                ++this.n;
                return true;
            }
            return false;
        }

        public void resetEndPoint() {
        }

        public void restart() {
            this.n = 0;
        }
    }
}

