/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.CustomOverlay;
import jas.hist.DataSource;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.LegendEntry;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Graphics;

class MyCustomOverlay
implements LegendEntry,
CustomOverlay {
    OverlayContainer container;
    ScatterPlotSource source;

    MyCustomOverlay() {
    }

    public void setDataSource(DataSource dataSource) {
        this.source = (ScatterPlotSource)dataSource;
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
    }

    public String getTitle() {
        return this.source.getTitle();
    }

    public void paint(PlotGraphics plotGraphics) {
        DateCoordinateTransformation dateCoordinateTransformation = (DateCoordinateTransformation)this.container.getXTransformation();
        DoubleCoordinateTransformation doubleCoordinateTransformation = (DoubleCoordinateTransformation)this.container.getYTransformation();
        DateTransformationConverter dateTransformationConverter = new DateTransformationConverter(dateCoordinateTransformation);
        plotGraphics.setTransformation(dateTransformationConverter, doubleCoordinateTransformation);
        plotGraphics.setColor(Color.blue);
        ScatterEnumeration scatterEnumeration = this.source.startEnumeration();
        double[] dArray = new double[2];
        double[] dArray2 = null;
        while (scatterEnumeration.getNextPoint(dArray)) {
            if (dArray2 != null) {
                plotGraphics.drawLine((double)dArray2[0], (double)dArray2[1], dArray[0], (double)dArray2[1]);
            }
            plotGraphics.drawSymbol(dArray[0], dArray[1], 5.0, 0);
            dArray2 = dArray;
            dArray = new double[2];
        }
    }

    public void containerNotify(OverlayContainer overlayContainer) {
        this.container = overlayContainer;
    }

    private class DateTransformationConverter
    implements DoubleCoordinateTransformation {
        private DateCoordinateTransformation source;

        DateTransformationConverter(DateCoordinateTransformation dateCoordinateTransformation) {
            this.source = dateCoordinateTransformation;
        }

        public double convert(double d) {
            return this.source.convert((long)(d * 1000.0));
        }

        public double unConvert(double d) {
            return (double)this.source.map(d) / 1000.0;
        }

        public double getPlotMin() {
            return (double)this.source.getAxisMin() / 1000.0;
        }

        public double getPlotMax() {
            return (double)this.source.getAxisMax() / 1000.0;
        }
    }
}

