/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DataSource;
import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FitterRegistry;
import jas.hist.FunctionAdvancedOptions;
import jas.hist.FunctionFactory;
import jas.hist.FunctionFactoryError;
import jas.hist.FunctionRegistry;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist;
import jas.hist.JASHist1DFunctionData;
import jas.hist.JASHist1DHistogramData;
import jas.hist.JASHistData;
import jas.hist.ManagedAxis;
import jas.hist.OneDDataManager;
import jas.hist.StatisticsBlock;
import jas.hist.SupportsFunctions;
import jas.hist.XYDataSource;
import jas.plot.DataArea;
import jas.plot.DateAxis;
import jas.plot.DoubleAxis;
import jas.plot.Legend;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class BinnedDataManager
extends OneDDataManager
implements SupportsFunctions {
    private int m_defaultNumberOfBins;
    protected final Vector funcs = new Vector();
    static /* synthetic */ Class class$java$awt$Frame;

    BinnedDataManager(JASHist jASHist, DataArea dataArea, Legend legend, StatisticsBlock statisticsBlock, int n) {
        super(jASHist, dataArea, legend, statisticsBlock);
        this.m_defaultNumberOfBins = n;
    }

    void XAxisUpdated() {
        Object object;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            object = (JASHist1DHistogramData)enumeration.nextElement();
            if (!((JASHistData)object).isShowing()) continue;
            ((JASHist1DHistogramData)object).setXRange(this.xm.getBins(), this.xLow, this.xHigh);
        }
        object = this.funcs.elements();
        while (object.hasMoreElements()) {
            JASHist1DFunctionData jASHist1DFunctionData = (JASHist1DFunctionData)object.nextElement();
            if (!jASHist1DFunctionData.isShowing()) continue;
            jASHist1DFunctionData.setXRange(this.xLow, this.xHigh);
        }
        this.ym[0].setAttentionNeeded();
        if (this.ym[1] != null) {
            this.ym[1].setAttentionNeeded();
        }
    }

    public JASHist1DFunctionData addFunction(Basic1DFunction basic1DFunction) {
        JASHist1DFunctionData jASHist1DFunctionData = new JASHist1DFunctionData(this, basic1DFunction);
        this.funcs.addElement(jASHist1DFunctionData);
        return jASHist1DFunctionData;
    }

    public void removeFunction(JASHist1DFunctionData jASHist1DFunctionData) {
        jASHist1DFunctionData.setShowing(false);
        jASHist1DFunctionData.destroy();
        this.funcs.removeElement(jASHist1DFunctionData);
    }

    public void destroy() {
        super.destroy();
        this.removeAllFunctions();
    }

    public void removeAllFunctions() {
        Enumeration enumeration = this.funcs.elements();
        while (enumeration.hasMoreElements()) {
            JASHist1DFunctionData jASHist1DFunctionData = (JASHist1DFunctionData)enumeration.nextElement();
            jASHist1DFunctionData.setShowing(false);
            jASHist1DFunctionData.destroy();
        }
        this.funcs.removeAllElements();
    }

    public int numberOfFunctions() {
        return this.funcs.size();
    }

    public Enumeration getFunctions() {
        return this.funcs.elements();
    }

    public final void update(HistogramUpdate histogramUpdate, JASHistData jASHistData) {
        super.update(histogramUpdate, jASHistData);
    }

    public final void update(JASHist1DFunctionData jASHist1DFunctionData) {
        SwingUtilities.invokeLater(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.funcs.trimToSize();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.data = new Vector();
        objectInputStream.defaultReadObject();
    }

    void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        super.modifyPopupMenu(jPopupMenu, component);
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new AddFunctionMenu());
        jPopupMenu.add(new RemoveFunctionMenu());
        jPopupMenu.add(new FitMenu());
        jPopupMenu.add(new AdvancedOptionsMenu());
    }

    public void fillFunctionMenu(JMenu jMenu) {
        jMenu.add(new AddFunctionMenu());
        jMenu.add(new RemoveFunctionMenu());
        jMenu.add(new FitMenu());
        jMenu.add(new AdvancedOptionsMenu());
    }

    void computeXAxisRange() {
        if (!this.xm.needsAttention()) {
            return;
        }
        this.xm.payingAttention();
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.xm.getRangeAutomatic()) {
            this.xLow = this.xm.getMin();
            this.xHigh = this.xm.getMax();
            return;
        }
        int n = 0;
        this.xLow = 0.0;
        this.xHigh = 0.0;
        boolean bl = false;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            JASHist1DHistogramData jASHist1DHistogramData = (JASHist1DHistogramData)enumeration.nextElement();
            if (!jASHist1DHistogramData.isShowing()) continue;
            if (n++ == 0) {
                this.xLow = jASHist1DHistogramData.getXMin();
                this.xHigh = jASHist1DHistogramData.getXMax();
            } else {
                this.xLow = Math.min(this.xLow, jASHist1DHistogramData.getXMin());
                this.xHigh = Math.max(this.xHigh, jASHist1DHistogramData.getXMax());
            }
            if (!jASHist1DHistogramData.isRebinnable()) continue;
            bl = true;
        }
        if (n == 0) {
            return;
        }
        this.xm.setBinned(bl);
        if (!this.xm.getAllowSuppressedZero()) {
            if (this.xLow > 0.0) {
                this.xLow = 0.0;
            }
            if (this.xHigh < 0.0) {
                this.xHigh = 0.0;
            }
        }
        if (this.xHigh <= this.xLow) {
            this.xHigh = this.xLow + 1.0;
        }
        this.calcMinMaxBins(this.xLow, this.xHigh);
    }

    void computeYAxisRange() {
        int n = 0;
        while (n < this.ym.length) {
            double d = 0.0;
            double d2 = 0.0;
            if (this.ym[n] != null && this.ym[n].needsAttention()) {
                Object object;
                this.ym[n].payingAttention();
                DoubleAxis doubleAxis = (DoubleAxis)this.ym[n].getType();
                if (this.data.isEmpty()) {
                    return;
                }
                if (!this.ym[n].getRangeAutomatic()) {
                    doubleAxis.setUseSuggestedRange(false);
                    doubleAxis.getAxis().invalidate();
                    Enumeration enumeration = this.data.elements();
                    while (enumeration.hasMoreElements()) {
                        object = (JASHist1DHistogramData)enumeration.nextElement();
                        if (!((JASHistData)object).isShowing() || ((JASHistData)object).getYAxis() != n) continue;
                        ((JASHist1DHistogramData)object).validate();
                    }
                } else {
                    boolean bl = true;
                    object = this.data.elements();
                    while (object.hasMoreElements()) {
                        JASHist1DHistogramData jASHist1DHistogramData = (JASHist1DHistogramData)object.nextElement();
                        if (!jASHist1DHistogramData.isShowing() || jASHist1DHistogramData.getYAxis() != n) continue;
                        if (bl) {
                            d = jASHist1DHistogramData.getYMin();
                            d2 = jASHist1DHistogramData.getYMax();
                            bl = false;
                            continue;
                        }
                        d = Math.min(d, jASHist1DHistogramData.getYMin());
                        d2 = Math.max(d2, jASHist1DHistogramData.getYMax());
                    }
                    if (!this.ym[n].getAllowSuppressedZero()) {
                        if (d > 0.0) {
                            d = 0.0;
                        }
                        if (d2 < 0.0) {
                            d2 = 0.0;
                        }
                    }
                    if (d2 <= d) {
                        d2 = d + 1.0;
                    }
                    if (this.ym[n].isLogarithmic()) {
                        d = Math.max(d, 1.0);
                    }
                    double d3 = doubleAxis.getPlotMin();
                    double d4 = doubleAxis.getPlotMax();
                    if (d < d3 || d2 > d4 || (d2 - d) / (d4 - d3) < 0.75) {
                        doubleAxis.setUseSuggestedRange(true);
                        doubleAxis.setMin(d);
                        doubleAxis.setMax(d2);
                        doubleAxis.getAxis().revalidate();
                    }
                }
            }
            ++n;
        }
    }

    abstract void calcMinMaxBins(double var1, double var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class AdvancedOptionsMenu
    extends JMenu {
        private boolean m_build;

        public AdvancedOptionsMenu() {
            super("Advanced options...");
            this.setMnemonic('o');
            Enumeration enumeration = BinnedDataManager.this.getFunctions();
            this.m_build = false;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    if (!(((JASHist1DFunctionData)enumeration.nextElement()).getFunction() instanceof FunctionAdvancedOptions)) continue;
                    this.m_build = true;
                    break;
                }
            }
            this.setEnabled(this.m_build);
        }

        protected void fireMenuSelected() {
            if (this.m_build) {
                this.m_build = false;
                this.removeAll();
                Enumeration enumeration = BinnedDataManager.this.getFunctions();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    Basic1DFunction basic1DFunction = ((JASHist1DFunctionData)enumeration.nextElement()).getFunction();
                    if (!(basic1DFunction instanceof FunctionAdvancedOptions)) continue;
                    this.add(new AdvancedOptionsMenuItem((FunctionAdvancedOptions)((Object)basic1DFunction), ++n));
                }
            }
        }

        private final class AdvancedOptionsMenuItem
        extends JMenuItem {
            private FunctionAdvancedOptions m_function;

            AdvancedOptionsMenuItem(FunctionAdvancedOptions functionAdvancedOptions, int n) {
                super(String.valueOf(n) + " " + ((Basic1DFunction)((Object)functionAdvancedOptions)).getTitle());
                this.m_function = functionAdvancedOptions;
                this.setMnemonic(48 + (char)n);
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                this.m_function.openAdvancedDialog((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = BinnedDataManager.class$("java.awt.Frame")) : class$java$awt$Frame, ((AdvancedOptionsMenu)AdvancedOptionsMenu.this).BinnedDataManager.this.plot), ((AdvancedOptionsMenu)AdvancedOptionsMenu.this).BinnedDataManager.this.plot);
            }
        }
    }

    private final class FitMenu
    extends JMenu {
        private JASHist1DHistogramData m_selectedDataSet;
        private boolean m_build;

        public FitMenu() {
            super("Fit");
            this.setMnemonic('F');
            this.m_build = false;
            if (BinnedDataManager.this.numberOfDataSources() > 0) {
                Enumeration enumeration = BinnedDataManager.this.getFunctions();
                while (enumeration.hasMoreElements()) {
                    Basic1DFunction basic1DFunction = ((JASHist1DFunctionData)enumeration.nextElement()).getFunction();
                    if (!(basic1DFunction instanceof Fittable1DFunction) || ((Fittable1DFunction)basic1DFunction).getFit() != null) continue;
                    this.m_build = true;
                    break;
                }
            }
            this.setEnabled(this.m_build);
        }

        private void buildMenu() {
            this.removeAll();
            this.m_build = false;
            if (BinnedDataManager.this.numberOfDataSources() > 1) {
                int n = 0;
                Enumeration enumeration = BinnedDataManager.this.getDataSources();
                while (enumeration.hasMoreElements()) {
                    this.add(new FitMenuDataMenu((JASHist1DHistogramData)enumeration.nextElement(), ++n));
                }
            } else {
                this.m_selectedDataSet = (JASHist1DHistogramData)BinnedDataManager.this.getDataSources().nextElement();
                Enumeration enumeration = BinnedDataManager.this.getFunctions();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    Basic1DFunction basic1DFunction = ((JASHist1DFunctionData)enumeration.nextElement()).getFunction();
                    if (!(basic1DFunction instanceof Fittable1DFunction) || ((Fittable1DFunction)basic1DFunction).getFit() != null) continue;
                    this.add(new FitMenuFunctionItem((Fittable1DFunction)basic1DFunction, ++n));
                }
            }
        }

        protected void fireMenuSelected() {
            if (this.m_build) {
                this.buildMenu();
            }
        }

        private final class FitMenuDataMenu
        extends JMenu {
            private boolean m_built = false;
            private JASHist1DHistogramData m_data;

            FitMenuDataMenu(JASHist1DHistogramData jASHist1DHistogramData, int n) {
                super(String.valueOf(n) + " " + jASHist1DHistogramData.getTitle());
                this.m_data = jASHist1DHistogramData;
                this.setMnemonic(48 + (char)n);
            }

            protected void fireMenuSelected() {
                FitMenu.this.m_selectedDataSet = this.m_data;
                if (!this.m_built) {
                    this.m_built = true;
                    this.removeAll();
                    Enumeration enumeration = BinnedDataManager.this.getFunctions();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        JASHist1DFunctionData jASHist1DFunctionData = (JASHist1DFunctionData)enumeration.nextElement();
                        DataSource dataSource = jASHist1DFunctionData.getDataSource();
                        if (!(dataSource instanceof Fittable1DFunction)) continue;
                        this.add(new FitMenuFunctionItem((Fittable1DFunction)dataSource, ++n));
                    }
                }
            }
        }

        private final class FitMenuFunctionItem
        extends JMenuItem {
            private Fittable1DFunction m_func;

            FitMenuFunctionItem(Fittable1DFunction fittable1DFunction, int n) {
                super(String.valueOf(n) + " " + fittable1DFunction.getTitle());
                this.m_func = fittable1DFunction;
                this.setMnemonic(48 + (char)n);
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                Fitter fitter = FitterRegistry.instance().getDefaultFitter();
                fitter.setFunction(this.m_func);
                fitter.setData((XYDataSource)FitMenu.this.m_selectedDataSet.getFittableDataSource());
                JASHist cfr_ignored_0 = ((FitMenu)FitMenu.this).BinnedDataManager.this.plot;
                JASHist.notifyFitListeners(fitter);
                fitter.start();
            }
        }
    }

    private final class RemoveFunctionMenu
    extends JMenu {
        private boolean m_build;
        private RemoveAll m_removeAll;

        public RemoveFunctionMenu() {
            super("Remove function");
            this.setMnemonic('R');
            this.m_removeAll = new RemoveAll();
            this.m_build = BinnedDataManager.this.numberOfFunctions() > 0;
            this.setEnabled(this.m_build);
        }

        private void buildMenu() {
            this.m_build = false;
            this.removeAll();
            int n = 0;
            Enumeration enumeration = BinnedDataManager.this.getFunctions();
            while (enumeration.hasMoreElements()) {
                this.add(new RemoveFunctionMenuItem((JASHist1DFunctionData)enumeration.nextElement(), ++n));
            }
            if (n > 1) {
                this.addSeparator();
                this.add(this.m_removeAll);
            }
        }

        protected void fireMenuSelected() {
            if (this.m_build) {
                this.buildMenu();
            }
        }

        private final class RemoveAll
        extends JMenuItem {
            RemoveAll() {
                super("Remove all");
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                BinnedDataManager.this.removeAllFunctions();
            }
        }

        private final class RemoveFunctionMenuItem
        extends JMenuItem {
            private JASHist1DFunctionData m_func;

            RemoveFunctionMenuItem(JASHist1DFunctionData jASHist1DFunctionData, int n) {
                super(String.valueOf(n) + ' ' + jASHist1DFunctionData.getTitle());
                this.m_func = jASHist1DFunctionData;
                this.setMnemonic(48 + (char)n);
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                BinnedDataManager.this.removeFunction(this.m_func);
            }
        }
    }

    private final class AddFunctionMenu
    extends JMenu {
        private boolean m_build;

        public AddFunctionMenu() {
            super("Add function");
            this.setMnemonic('A');
            this.m_build = FitterRegistry.instance().getDefaultFitter() != null && FunctionRegistry.instance().size() > 0;
            this.setEnabled(this.m_build);
        }

        private void buildMenu() {
            this.removeAll();
            int n = 0;
            Enumeration enumeration = FunctionRegistry.instance().elements();
            while (enumeration.hasMoreElements()) {
                this.add(new AddFunctionMenuItem((FunctionFactory)enumeration.nextElement(), ++n));
            }
            this.m_build = false;
        }

        protected void fireMenuSelected() {
            if (this.m_build) {
                this.buildMenu();
            }
        }

        private final class AddFunctionMenuItem
        extends JMenuItem {
            private FunctionFactory m_func;

            AddFunctionMenuItem(FunctionFactory functionFactory, int n) {
                super(String.valueOf(n) + ' ' + functionFactory.getFunctionName());
                this.m_func = functionFactory;
                this.setMnemonic(48 + (char)n);
            }

            protected void fireActionPerformed(ActionEvent actionEvent) {
                try {
                    BinnedDataManager.this.addFunction(this.m_func.createFunction(((AddFunctionMenu)AddFunctionMenu.this).BinnedDataManager.this.plot)).show(true);
                }
                catch (FunctionFactoryError functionFactoryError) {
                    JOptionPane.showMessageDialog(this, "Could not add function.");
                }
            }
        }
    }

    abstract class AxisListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected double xLowOld;
        protected double grab;
        protected int grabType;
        protected ManagedAxis axis;
        protected Cursor oldCursor;

        AxisListener(ManagedAxis managedAxis) {
            this.axis = managedAxis;
            managedAxis.addMouseListener(this);
            managedAxis.addMouseMotionListener(this);
            managedAxis.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.axis.getMinLocation();
            int n2 = this.axis.getMaxLocation();
            double d = (double)mouseEvent.getX() / (double)(n2 - n);
            this.oldCursor = this.axis.getCursor();
            if (d < 0.2) {
                this.grabType = 0;
                this.grab = BinnedDataManager.this.xLow + d * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                this.axis.setCursor(Cursor.getPredefinedCursor(11));
            } else if (d > 0.8) {
                this.grabType = 1;
                this.grab = BinnedDataManager.this.xLow + d * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                this.axis.setCursor(Cursor.getPredefinedCursor(10));
            } else {
                this.grabType = 2;
                this.grab = d;
                this.xLowOld = BinnedDataManager.this.xLow;
                this.axis.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.axis.setCursor(this.oldCursor);
        }
    }

    protected final class DoubleAxisListener
    extends AxisListener {
        private DoubleAxis axisType;

        DoubleAxisListener(ManagedAxis managedAxis) {
            super(managedAxis);
            this.axisType = (DoubleAxis)managedAxis.getType();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.axis.getMinLocation();
            int n2 = this.axis.getMaxLocation();
            double d = (double)mouseEvent.getX() / (double)(n2 - n);
            if (this.grabType == 1) {
                BinnedDataManager.this.xHigh = BinnedDataManager.this.xLow + (this.grab - BinnedDataManager.this.xLow) / d;
                this.axisType.setMax(BinnedDataManager.this.xHigh);
            } else if (this.grabType == 0) {
                BinnedDataManager.this.xLow = BinnedDataManager.this.xHigh - (BinnedDataManager.this.xHigh - this.grab) / (1.0 - d);
                this.axisType.setMin(BinnedDataManager.this.xLow);
            } else {
                double d2 = (this.grab - d) * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                BinnedDataManager.this.xHigh = this.xLowOld + d2 + BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow;
                BinnedDataManager.this.xLow = this.xLowOld + d2;
                this.axisType.setMin(BinnedDataManager.this.xLow);
                this.axisType.setMax(BinnedDataManager.this.xHigh);
            }
            this.axis.setRangeAutomatic(false);
            BinnedDataManager.this.XAxisUpdated();
            BinnedDataManager.this.computeYAxisRange();
            BinnedDataManager.this.da.repaint();
        }
    }

    protected final class DateAxisListener
    extends AxisListener {
        private DateAxis axisType;

        DateAxisListener(ManagedAxis managedAxis) {
            super(managedAxis);
            this.axisType = (DateAxis)managedAxis.getType();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.axis.getMinLocation();
            int n2 = this.axis.getMaxLocation();
            double d = (double)mouseEvent.getX() / (double)(n2 - n);
            if (this.grabType == 1) {
                BinnedDataManager.this.xHigh = BinnedDataManager.this.xLow + (this.grab - BinnedDataManager.this.xLow) / d;
                this.axisType.setMax((long)(BinnedDataManager.this.xHigh * 1000.0));
            } else if (this.grabType == 0) {
                BinnedDataManager.this.xLow = BinnedDataManager.this.xHigh - (BinnedDataManager.this.xHigh - this.grab) / (1.0 - d);
                this.axisType.setMin((long)(BinnedDataManager.this.xLow * 1000.0));
            } else {
                double d2 = (this.grab - d) * (BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow);
                BinnedDataManager.this.xHigh = this.xLowOld + d2 + BinnedDataManager.this.xHigh - BinnedDataManager.this.xLow;
                BinnedDataManager.this.xLow = this.xLowOld + d2;
                this.axisType.setMin((long)(BinnedDataManager.this.xLow * 1000.0));
                this.axisType.setMax((long)(BinnedDataManager.this.xHigh * 1000.0));
            }
            this.axis.setRangeAutomatic(false);
            BinnedDataManager.this.XAxisUpdated();
            BinnedDataManager.this.computeYAxisRange();
            BinnedDataManager.this.da.repaint();
        }
    }
}

