#Check environment variables:

[[ ! -d "$SCT_DAQ_ROOT" ]] && echo "SCT_DAQ_ROOT not set or not a directory.  It should point to the directory this file is in" && return

[[ ! -d "$SCT_SCRATCH_DIR" ]] && echo "SCT_SCRATCH_DIR not set or not a directory.  This directory needs to be readable/writable by the SBC and all the fitting and analysis machines. \
It has been set to the default which is /tmp."

[[ ! -d "$TDAQ_INST_PATH" ]] && echo "TDAQ_INST_PATH not set or not a directory.  You need to setup the online software first!" && return

[[ ! -d "$ROOTSYS" ]] && echo "ROOTSYS not set or not a directory.  You need to setup Root first!" && return

[[ -z `echo $PATH | grep $ROOTSYS/bin` ]] && echo "PATH not set correctly.  Please make sure $ROOTSYS/bin is in the path" && return

[[ -z `echo $LD_LIBRARY_PATH | grep $ROOTSYS/lib` ]] && echo "LD_LIBRARY_PATH not set correctly.  Please make sure $ROOTSYS/lib is in LD_LIBRARY_PATH" && return

[[ ! -d "$DF_INST_PATH" ]] && echo "DF_INST_PATH not set or not a directory.  Please setup the Dataflow software correctly"

[[ -z `echo $PATH | grep $DF_INST_PATH/$CMTCONFIG/bin` ]] && echo "PATH not set correctly.  Please make sure $DF_INST_PATH/$CMTCONFIG/bin is in the path"

[[ -z `echo $LD_LIBRARY_PATH | grep $DF_INST_PATH/$CMTCONFIG/lib` ]] && echo "LD_LIBRARY_PATH not set correctly.  Please make sure $DF_INST_PATH/$CMTCONFIG/lib is in LD_LIBRARY_PATH" 


if [ ! -e "$SCTDAQ_ROD_CONFIGURATION_PATH" ]; then 
   echo "**** SCTDAQ_ROD_CONFIGURATION_PATH not set or doesn't exist.  This should point to your configuration files for your rod."
   echo "**** It has been set to the default for using the DUMMY software" 
   echo "**** You should modify exampleRod.xml or use sctConfGUI to use a real setup"
   export SCTDAQ_ROD_CONFIGURATION_PATH=$SCT_DAQ_ROOT/installed/config/rods/TestRod.xml
   echo "SCTDAQ_ROD_CONFIGURATION_PATH=$SCTDAQ_ROD_CONFIGURATION_PATH"
fi
   
if [ ! -e "$TDAQ_DB_DATA" ]; then 
   echo "**** TDAQ_DB_DATA not set or doesn't exist.  This should point to your configuration files for your partition."
   echo "**** It has been set to the default for using the DUMMY software"
   echo "**** Use SCT.data.xml for the real software"
   export TDAQ_DB_DATA=$SCT_DAQ_ROOT/installed/config/databases/SCT_test.data.xml
   echo "TDAQ_DB_DATA=$TDAQ_DB_DATA"
fi

if [ ! -d "$SCTPIXEL_DAQ_ROOT" ]; then
    export SCTPIXEL_DAQ_ROOT=$SCT_DAQ_ROOT/RodDaq
fi

export ROD_TYPE=SCT_ROD
export PATH=$PATH:$SCT_DAQ_ROOT/installed/$CMTCONFIG/bin:$SCT_DAQ_ROOT/installed/share/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$SCT_DAQ_ROOT/installed/$CMTCONFIG/lib


