// Mainpage for Doxygen

/** @mainpage package RodUtils
 *
 * @section intro Introduction
 *  This package contains test programs and utilities supporting classes
 * in RodCrate. It was formerly called RodTests.
 *
 * @authors Tom Meyer, Iowa State University (meyer@iastate.edu), John Hill
 (hill@hep.phy.cam.ac.uk), John Lane (jbl@hep.ucl.ac.uk)
 *
 *<hr>
 *       - Test programs
 *          -# BocTest - tests BocCard class
 *          -# Echo2Test - executes a command list of three echo primitives
 *          -# EchoTest - executes a command list of one echo primitive
 *          -# FlashTest - tests RodModule methods to read/write FPGA flash mems
 *          -# LedTest - Blinks a front panel LED via slave primitives
 *          -# TimModuleTest - tests TimModule class 
 *       - General Utilities
 *          -# DspDump - dumps the memory for any of the DSPs (incl. master)
 *          -# FlashDump - dumps contents of any FPGA flash memory
 *          -# FlashLoad - loads binary file into an FPGA flash memory
 *          -# MdspDump - dumps the memory for master DSP
 *          -# MdspFlashLoad - loads the MDSP program into flash memory
 *          -# TouchRod - Reads the ROD serian number and does sanity checks 
 *          -# MdspPeek - looks at MDSP memory space without resetting the ROD
 *          -# DspPeek - looks at any DSP memory space without resetting the ROD
 *          -# TextPeek - dumps MDSP text buffers in both hex and ASCII
 *          -# RegPeek - dumps MDSP status and control registers
 *          -# MdspSnap - takes a "snapshot" of the master DSP, dumping
 *                primlist and reply buffers, all text buffers, and the
 *                command and status registers. It does not reset the ROD.
 *          -# SlvSnap - Takes a "snapshot" of a slave DSP, containing the same
 *                items as in MdspSnap, above. It does not reset the ROD, but it
 *                works only if the slave is not running.
 *          -# AddressList - generates a table of DSP addresses from the header
 *                files and prints it to standard output.
 *
 * @section releasenotes  Notes for current release
 * release.notes
 *<hr>
 * @todo 
 */
